/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.gridfs.GridFSFindIterable;
import com.mongodb.client.gridfs.model.GridFSFile;
import java.io.InputStream;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.jspecify.annotations.Nullable;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.gridfs.GridFsObject;
import org.springframework.data.mongodb.gridfs.GridFsResource;
import org.springframework.data.mongodb.gridfs.GridFsUpload;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public interface GridFsOperations
extends ResourcePatternResolver {
    default public ObjectId store(InputStream content, String filename) {
        return this.store(content, filename, null, null);
    }

    default public ObjectId store(InputStream content, @Nullable Object metadata) {
        return this.store(content, null, metadata);
    }

    default public ObjectId store(InputStream content, @Nullable Document metadata) {
        return this.store(content, (String)null, metadata);
    }

    default public ObjectId store(InputStream content, @Nullable String filename, @Nullable String contentType) {
        return this.store(content, filename, contentType, null);
    }

    default public ObjectId store(InputStream content, @Nullable String filename, @Nullable Object metadata) {
        return this.store(content, filename, null, metadata);
    }

    public ObjectId store(InputStream var1, @Nullable String var2, @Nullable String var3, @Nullable Object var4);

    default public ObjectId store(InputStream content, @Nullable String filename, @Nullable Document metadata) {
        return this.store(content, filename, (String)null, metadata);
    }

    default public ObjectId store(InputStream content, @Nullable String filename, @Nullable String contentType, @Nullable Document metadata) {
        GridFsUpload.GridFsUploadBuilder<ObjectId> uploadBuilder = GridFsUpload.fromStream(content);
        if (StringUtils.hasText((String)filename)) {
            uploadBuilder.filename(filename);
        }
        if (!ObjectUtils.isEmpty((Object)metadata)) {
            uploadBuilder.metadata(metadata);
        }
        if (StringUtils.hasText((String)contentType)) {
            uploadBuilder.contentType(contentType);
        }
        return (ObjectId)this.store(uploadBuilder.build());
    }

    public <T> T store(GridFsObject<T, InputStream> var1);

    public GridFSFindIterable find(Query var1);

    public @Nullable GridFSFile findOne(Query var1);

    public void delete(Query var1);

    public GridFsResource getResource(String var1);

    public GridFsResource getResource(GridFSFile var1);

    public GridFsResource[] getResources(String var1);
}

