/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.index;

import java.util.function.Supplier;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.index.SearchIndexDefinition;
import org.springframework.data.mongodb.core.index.SearchIndexStatus;
import org.springframework.data.mongodb.core.index.VectorIndex;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;

public class SearchIndexInfo {
    private final @Nullable Object id;
    private final SearchIndexStatus status;
    private final Lazy<SearchIndexDefinition> indexDefinition;

    SearchIndexInfo(@Nullable Object id, SearchIndexStatus status, Supplier<SearchIndexDefinition> indexDefinition) {
        this.id = id;
        this.status = status;
        this.indexDefinition = Lazy.of(indexDefinition);
    }

    public static SearchIndexInfo parse(String source) {
        return SearchIndexInfo.of(Document.parse((String)source));
    }

    public static SearchIndexInfo of(Document indexDocument) {
        Object id = indexDocument.get((Object)"id");
        SearchIndexStatus status = SearchIndexStatus.valueOf((String)indexDocument.get((Object)"status", (Object)SearchIndexStatus.DOES_NOT_EXIST.name()));
        return new SearchIndexInfo(id, status, () -> SearchIndexInfo.readIndexDefinition(indexDocument));
    }

    public @Nullable Object getId() {
        return this.id;
    }

    public SearchIndexStatus getStatus() {
        return this.status;
    }

    public SearchIndexDefinition getIndexDefinition() {
        return (SearchIndexDefinition)this.indexDefinition.get();
    }

    private static SearchIndexDefinition readIndexDefinition(final Document document) {
        final String type = (String)document.get((Object)"type", (Object)"search");
        if (type.equals("vectorSearch")) {
            return VectorIndex.of(document);
        }
        return new SearchIndexDefinition(){

            @Override
            public String getName() {
                return document.getString((Object)"name");
            }

            @Override
            public String getType() {
                return type;
            }

            @Override
            public Document getDefinition(@Nullable TypeInformation<?> entity, @Nullable MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext) {
                if (document.containsKey((Object)"latestDefinition")) {
                    return (Document)document.get((Object)"latestDefinition", (Object)new Document());
                }
                return (Document)document.get((Object)"definition", (Object)new Document());
            }

            public String toString() {
                return this.getDefinition(null, null).toJson();
            }
        };
    }
}

