/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.encryption;

import com.mongodb.client.model.vault.EncryptOptions;
import com.mongodb.client.model.vault.RangeOptions;
import com.mongodb.client.vault.ClientEncryption;
import java.util.Map;
import java.util.function.Supplier;
import org.bson.BsonBinary;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.springframework.data.mongodb.core.encryption.Encryption;
import org.springframework.data.mongodb.core.encryption.EncryptionKey;
import org.springframework.data.mongodb.core.encryption.EncryptionOptions;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.util.Assert;

public class MongoClientEncryption
implements Encryption<BsonValue, BsonBinary> {
    private final Supplier<ClientEncryption> source;

    MongoClientEncryption(Supplier<ClientEncryption> source) {
        this.source = source;
    }

    public static MongoClientEncryption just(ClientEncryption clientEncryption) {
        Assert.notNull((Object)clientEncryption, (String)"ClientEncryption must not be null");
        return new MongoClientEncryption(() -> clientEncryption);
    }

    @Override
    public BsonValue decrypt(BsonBinary value) {
        return this.getClientEncryption().decrypt(value);
    }

    @Override
    public BsonBinary encrypt(BsonValue value, EncryptionOptions options) {
        return this.getClientEncryption().encrypt(value, this.createEncryptOptions(options));
    }

    @Override
    public BsonDocument encryptExpression(BsonDocument value, EncryptionOptions options) {
        return this.getClientEncryption().encryptExpression((Bson)value, this.createEncryptOptions(options));
    }

    public ClientEncryption getClientEncryption() {
        return this.source.get();
    }

    private EncryptOptions createEncryptOptions(EncryptionOptions options) {
        EncryptOptions encryptOptions = new EncryptOptions(options.algorithm());
        encryptOptions = EncryptionKey.Type.ALT.equals((Object)options.key().type()) ? encryptOptions.keyAltName(options.key().value().toString()) : encryptOptions.keyId((BsonBinary)options.key().value());
        if (options.queryableEncryptionOptions() == null) {
            return encryptOptions;
        }
        EncryptionOptions.QueryableEncryptionOptions qeOptions = options.queryableEncryptionOptions();
        if (qeOptions.getQueryType() != null) {
            encryptOptions.queryType(qeOptions.getQueryType());
        }
        if (qeOptions.getContentionFactor() != null) {
            encryptOptions.contentionFactor(qeOptions.getContentionFactor());
        }
        if (!qeOptions.getAttributes().isEmpty()) {
            encryptOptions.rangeOptions(this.rangeOptions(qeOptions.getAttributes()));
        }
        return encryptOptions;
    }

    protected RangeOptions rangeOptions(Map<String, Object> attributes) {
        RangeOptions encryptionRangeOptions = new RangeOptions();
        if (attributes.isEmpty()) {
            return encryptionRangeOptions;
        }
        if (attributes.containsKey("min")) {
            encryptionRangeOptions.min(BsonUtils.simpleToBsonValue(attributes.get("min")));
        }
        if (attributes.containsKey("max")) {
            encryptionRangeOptions.max(BsonUtils.simpleToBsonValue(attributes.get("max")));
        }
        if (attributes.containsKey("trimFactor")) {
            Object trimFactor = attributes.get("trimFactor");
            Assert.isInstanceOf(Integer.class, (Object)trimFactor, () -> String.format("Expected to find a %s but it turned out to be %s.", Integer.class, trimFactor.getClass()));
            encryptionRangeOptions.trimFactor((Integer)trimFactor);
        }
        if (attributes.containsKey("sparsity")) {
            Object sparsity = attributes.get("sparsity");
            Assert.isInstanceOf(Number.class, (Object)sparsity, () -> String.format("Expected to find a %s but it turned out to be %s.", Long.class, sparsity.getClass()));
            encryptionRangeOptions.sparsity(Long.valueOf(((Number)sparsity).longValue()));
        }
        if (attributes.containsKey("precision")) {
            Object precision = attributes.get("precision");
            Assert.isInstanceOf(Number.class, (Object)precision, () -> String.format("Expected to find a %s but it turned out to be %s.", Integer.class, precision.getClass()));
            encryptionRangeOptions.precision(Integer.valueOf(((Number)precision).intValue()));
        }
        return encryptionRangeOptions;
    }
}

