/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.AggregationVariable;

public enum SystemVariable implements AggregationVariable
{
    NOW,
    CLUSTER_TIME,
    ROOT,
    CURRENT,
    REMOVE,
    DESCEND,
    PRUNE,
    KEEP,
    SEARCH_META;


    public static boolean isReferingToSystemVariable(@Nullable String fieldRef) {
        String candidate = SystemVariable.variableNameFrom(fieldRef);
        if (candidate == null) {
            return false;
        }
        candidate = candidate.startsWith("$$") ? candidate.substring(2) : candidate;
        for (SystemVariable value : SystemVariable.values()) {
            if (!value.name().equals(candidate)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "$$".concat(this.name());
    }

    @Override
    public String getTarget() {
        return this.toString();
    }

    static @Nullable String variableNameFrom(@Nullable String fieldRef) {
        if (fieldRef == null || !fieldRef.startsWith("$$") || fieldRef.length() <= 2) {
            return null;
        }
        int indexOfFirstDot = fieldRef.indexOf(46);
        return indexOfFirstDot == -1 ? fieldRef : fieldRef.substring(2, indexOfFirstDot);
    }
}

