/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.AbstractAggregationExpression;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class ScriptOperators {
    public static Function function(String body) {
        return Function.function(body);
    }

    public static Accumulator.AccumulatorInitBuilder accumulatorBuilder() {
        return new Accumulator.AccumulatorBuilder();
    }

    public static class Function
    extends AbstractAggregationExpression {
        private Function(Map<String, Object> values) {
            super(values);
        }

        public static Function function(String body) {
            Assert.notNull((Object)body, (String)"Function body must not be null");
            LinkedHashMap<String, Object> function = new LinkedHashMap<String, Object>(2);
            function.put(Fields.BODY.toString(), body);
            function.put(Fields.ARGS.toString(), Collections.emptyList());
            function.put(Fields.LANG.toString(), "js");
            return new Function(function);
        }

        public Function args(Object ... args) {
            return this.args(Arrays.asList(args));
        }

        public Function args(List<Object> args) {
            Assert.notNull(args, (String)"Args must not be null Use an empty list instead");
            return new Function(this.appendAt(1, Fields.ARGS.toString(), args));
        }

        public Function lang(String lang) {
            Assert.hasText((String)lang, (String)"Lang must not be null nor empty; The default would be 'js'");
            return new Function(this.appendAt(2, Fields.LANG.toString(), lang));
        }

        @Nullable List<Object> getArgs() {
            return (List)this.get(Fields.ARGS.toString());
        }

        @Nullable String getBody() {
            return (String)this.get(Fields.BODY.toString());
        }

        @Nullable String getLang() {
            return (String)this.get(Fields.LANG.toString());
        }

        @Override
        protected String getMongoMethod() {
            return "$function";
        }

        static enum Fields {
            BODY,
            ARGS,
            LANG;


            public String toString() {
                return this.name().toLowerCase();
            }
        }
    }

    public static class Accumulator
    extends AbstractAggregationExpression {
        private Accumulator(Map<String, Object> value) {
            super(value);
        }

        @Override
        protected String getMongoMethod() {
            return "$accumulator";
        }

        static class AccumulatorBuilder
        implements AccumulatorInitBuilder,
        AccumulatorInitArgsBuilder,
        AccumulatorAccumulateBuilder,
        AccumulatorAccumulateArgsBuilder,
        AccumulatorMergeBuilder,
        AccumulatorFinalizeBuilder {
            private @Nullable List<Object> initArgs;
            private @Nullable String initFunction;
            private @Nullable List<Object> accumulateArgs;
            private @Nullable String accumulateFunction;
            private @Nullable String mergeFunction;
            private @Nullable String finalizeFunction;
            private String lang = "js";

            AccumulatorBuilder() {
            }

            @Override
            @Contract(value="_ -> this")
            public AccumulatorBuilder init(String function) {
                this.initFunction = function;
                return this;
            }

            @Override
            @Contract(value="_ -> this")
            public AccumulatorBuilder initArgs(List<Object> args) {
                Assert.notNull(args, (String)"Args must not be null");
                this.initArgs = new ArrayList<Object>(args);
                return this;
            }

            @Override
            @Contract(value="_ -> this")
            public AccumulatorBuilder accumulate(String function) {
                Assert.notNull((Object)function, (String)"Accumulate function must not be null");
                this.accumulateFunction = function;
                return this;
            }

            @Override
            @Contract(value="_ -> this")
            public AccumulatorBuilder accumulateArgs(List<Object> args) {
                Assert.notNull(args, (String)"Args must not be null");
                this.accumulateArgs = new ArrayList<Object>(args);
                return this;
            }

            @Override
            @Contract(value="_ -> this")
            public AccumulatorBuilder merge(String function) {
                Assert.notNull((Object)function, (String)"Merge function must not be null");
                this.mergeFunction = function;
                return this;
            }

            @Override
            @Contract(value="_ -> this")
            public AccumulatorBuilder lang(String lang) {
                Assert.hasText((String)lang, (String)"Lang must not be null nor empty; The default would be 'js'");
                this.lang = lang;
                return this;
            }

            @Override
            @Contract(value="_ -> new")
            public Accumulator finalize(String function) {
                Assert.notNull((Object)function, (String)"Finalize function must not be null");
                this.finalizeFunction = function;
                Map<String, Object> args = this.createArgumentMap();
                args.put(Fields.FINALIZE.toString(), this.finalizeFunction);
                return new Accumulator(args);
            }

            @Override
            @Contract(value="-> new")
            public Accumulator build() {
                return new Accumulator(this.createArgumentMap());
            }

            private Map<String, Object> createArgumentMap() {
                LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
                args.put(Fields.INIT.toString(), this.initFunction);
                if (!CollectionUtils.isEmpty(this.initArgs)) {
                    args.put(Fields.INIT_ARGS.toString(), this.initArgs);
                }
                args.put(Fields.ACCUMULATE.toString(), this.accumulateFunction);
                if (!CollectionUtils.isEmpty(this.accumulateArgs)) {
                    args.put(Fields.ACCUMULATE_ARGS.toString(), this.accumulateArgs);
                }
                args.put(Fields.MERGE.toString(), this.mergeFunction);
                args.put(Fields.LANG.toString(), this.lang);
                return args;
            }
        }

        public static interface AccumulatorFinalizeBuilder {
            public Accumulator finalize(String var1);

            public Accumulator build();
        }

        public static interface AccumulatorMergeBuilder {
            public AccumulatorFinalizeBuilder merge(String var1);
        }

        public static interface AccumulatorAccumulateArgsBuilder
        extends AccumulatorMergeBuilder {
            default public AccumulatorMergeBuilder accumulateArgs(Object ... args) {
                return this.accumulateArgs(Arrays.asList(args));
            }

            public AccumulatorMergeBuilder accumulateArgs(List<Object> var1);
        }

        public static interface AccumulatorAccumulateBuilder {
            default public AccumulatorMergeBuilder accumulate(Function function) {
                Assert.notNull((Object)function.getBody(), (String)"Function body must not be null");
                List<Object> args = function.getArgs();
                return this.accumulate(function.getBody()).accumulateArgs(args != null ? args : List.of());
            }

            public AccumulatorAccumulateArgsBuilder accumulate(String var1);
        }

        public static interface AccumulatorInitArgsBuilder
        extends AccumulatorAccumulateBuilder {
            default public AccumulatorAccumulateBuilder initArgs(Object ... args) {
                return this.initArgs(Arrays.asList(args));
            }

            public AccumulatorAccumulateBuilder initArgs(List<Object> var1);
        }

        public static interface AccumulatorInitBuilder {
            default public AccumulatorAccumulateBuilder init(Function function) {
                Assert.notNull((Object)function.getBody(), (String)"Function body must not be null");
                List<Object> args = function.getArgs();
                return this.init(function.getBody()).initArgs(args != null ? args : List.of());
            }

            public AccumulatorInitArgsBuilder init(String var1);

            public AccumulatorInitBuilder lang(String var1);
        }

        static enum Fields {
            ACCUMULATE("accumulate"),
            ACCUMULATE_ARGS("accumulateArgs"),
            FINALIZE("finalize"),
            INIT("init"),
            INIT_ARGS("initArgs"),
            LANG("lang"),
            MERGE("merge");

            private final String field;

            private Fields(String field) {
                this.field = field;
            }

            public String toString() {
                return this.field;
            }
        }
    }
}

