/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.MongoClientSettings;
import com.mongodb.reactivestreams.client.MongoClient;
import com.mongodb.reactivestreams.client.MongoClients;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.core.MongoExceptionTranslator;
import org.springframework.util.StringUtils;

public class ReactiveMongoClientFactoryBean
extends AbstractFactoryBean<MongoClient>
implements PersistenceExceptionTranslator {
    private @Nullable String connectionString;
    private @Nullable String host;
    private @Nullable Integer port;
    private @Nullable MongoClientSettings mongoClientSettings;
    private PersistenceExceptionTranslator exceptionTranslator = MongoExceptionTranslator.DEFAULT_EXCEPTION_TRANSLATOR;

    public void setHost(@Nullable String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setConnectionString(@Nullable String connectionString) {
        this.connectionString = connectionString;
    }

    public void setMongoClientSettings(@Nullable MongoClientSettings mongoClientSettings) {
        this.mongoClientSettings = mongoClientSettings;
    }

    public void setExceptionTranslator(@Nullable PersistenceExceptionTranslator exceptionTranslator) {
        this.exceptionTranslator = exceptionTranslator == null ? MongoExceptionTranslator.DEFAULT_EXCEPTION_TRANSLATOR : exceptionTranslator;
    }

    public @Nullable DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        return this.exceptionTranslator.translateExceptionIfPossible(ex);
    }

    public Class<?> getObjectType() {
        return MongoClient.class;
    }

    protected MongoClient createInstance() throws Exception {
        if (this.mongoClientSettings != null) {
            return MongoClients.create((MongoClientSettings)this.mongoClientSettings);
        }
        if (StringUtils.hasText((String)this.connectionString)) {
            return MongoClients.create((String)this.connectionString);
        }
        if (StringUtils.hasText((String)this.host)) {
            if (this.port != null) {
                return MongoClients.create((String)String.format("mongodb://%s:%d", this.host, this.port));
            }
            return MongoClients.create((String)String.format("mongodb://%s", this.host));
        }
        throw new IllegalStateException("Cannot create MongoClients; One of the following is required: mongoClientSettings, connectionString or host/port");
    }

    protected void destroyInstance(@Nullable MongoClient instance) throws Exception {
        if (instance != null) {
            instance.close();
        }
    }
}

