/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core;

import com.mongodb.client.result.UpdateResult;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.ExecutableUpdateOperation;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.FindAndReplaceOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.QueryResultConverter;
import org.springframework.data.mongodb.core.ReplaceOptions;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class ExecutableUpdateOperationSupport
implements ExecutableUpdateOperation {
    private static final Query ALL_QUERY = new Query();
    private final MongoTemplate template;

    ExecutableUpdateOperationSupport(MongoTemplate template) {
        this.template = template;
    }

    @Override
    @Contract(value="_ -> new")
    public <T> ExecutableUpdateOperation.ExecutableUpdate<T> update(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null");
        return new ExecutableUpdateSupport(this.template, domainType, ALL_QUERY, null, null, null, null, null, domainType, QueryResultConverter.entity());
    }

    static class ExecutableUpdateSupport<S, T>
    implements ExecutableUpdateOperation.ExecutableUpdate<T>,
    ExecutableUpdateOperation.UpdateWithCollection<T>,
    ExecutableUpdateOperation.UpdateWithQuery<T>,
    ExecutableUpdateOperation.TerminatingUpdate<T>,
    ExecutableUpdateOperation.FindAndReplaceWithOptions<T>,
    ExecutableUpdateOperation.TerminatingFindAndReplace<T>,
    ExecutableUpdateOperation.FindAndReplaceWithProjection<T> {
        private final MongoTemplate template;
        private final Class<?> domainType;
        private final Query query;
        private final @Nullable UpdateDefinition update;
        private final @Nullable String collection;
        private final @Nullable FindAndModifyOptions findAndModifyOptions;
        private final @Nullable FindAndReplaceOptions findAndReplaceOptions;
        private final @Nullable Object replacement;
        private final QueryResultConverter<? super S, ? extends T> resultConverter;
        private final Class<S> targetType;

        ExecutableUpdateSupport(MongoTemplate template, Class<?> domainType, Query query, @Nullable UpdateDefinition update, @Nullable String collection, @Nullable FindAndModifyOptions findAndModifyOptions, @Nullable FindAndReplaceOptions findAndReplaceOptions, @Nullable Object replacement, Class<S> targetType, QueryResultConverter<? super S, ? extends T> resultConverter) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.update = update;
            this.collection = collection;
            this.findAndModifyOptions = findAndModifyOptions;
            this.findAndReplaceOptions = findAndReplaceOptions;
            this.replacement = replacement;
            this.targetType = targetType;
            this.resultConverter = resultConverter;
        }

        @Override
        @Contract(value="_ -> new")
        public ExecutableUpdateOperation.TerminatingUpdate<T> apply(UpdateDefinition update) {
            Assert.notNull((Object)update, (String)"Update must not be null");
            return new ExecutableUpdateSupport<S, T>(this.template, this.domainType, this.query, update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType, this.resultConverter);
        }

        @Override
        @Contract(value="_ -> new")
        public ExecutableUpdateOperation.UpdateWithQuery<T> inCollection(String collection) {
            Assert.hasText((String)collection, (String)"Collection must not be null nor empty");
            return new ExecutableUpdateSupport<S, T>(this.template, this.domainType, this.query, this.update, collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType, this.resultConverter);
        }

        @Override
        @Contract(value="_ -> new")
        public ExecutableUpdateOperation.TerminatingFindAndModify<T> withOptions(FindAndModifyOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null");
            return new ExecutableUpdateSupport<S, T>(this.template, this.domainType, this.query, this.update, this.collection, options, this.findAndReplaceOptions, this.replacement, this.targetType, this.resultConverter);
        }

        @Override
        @Contract(value="_ -> new")
        public ExecutableUpdateOperation.FindAndReplaceWithProjection<T> replaceWith(T replacement) {
            Assert.notNull(replacement, (String)"Replacement must not be null");
            return new ExecutableUpdateSupport<S, T>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, replacement, this.targetType, this.resultConverter);
        }

        @Override
        @Contract(value="_ -> new")
        public ExecutableUpdateOperation.FindAndReplaceWithProjection<T> withOptions(FindAndReplaceOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null");
            return new ExecutableUpdateSupport<S, T>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, options, this.replacement, this.targetType, this.resultConverter);
        }

        @Override
        @Contract(value="_ -> new")
        public ExecutableUpdateOperation.TerminatingReplace withOptions(ReplaceOptions options) {
            FindAndReplaceOptions target = new FindAndReplaceOptions();
            if (options.isUpsert()) {
                target.upsert();
            }
            return new ExecutableUpdateSupport<S, T>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, target, this.replacement, this.targetType, this.resultConverter);
        }

        @Override
        @Contract(value="_ -> new")
        public ExecutableUpdateOperation.UpdateWithUpdate<T> matching(Query query) {
            Assert.notNull((Object)query, (String)"Query must not be null");
            return new ExecutableUpdateSupport<S, T>(this.template, this.domainType, query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType, this.resultConverter);
        }

        @Override
        @Contract(value="_ -> new")
        public <R> ExecutableUpdateOperation.FindAndReplaceWithOptions<R> as(Class<R> resultType) {
            Assert.notNull(resultType, (String)"ResultType must not be null");
            return new ExecutableUpdateSupport(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, resultType, QueryResultConverter.entity());
        }

        @Override
        public UpdateResult all() {
            return this.doUpdate(true, false);
        }

        @Override
        public UpdateResult first() {
            return this.doUpdate(false, false);
        }

        @Override
        public UpdateResult upsert() {
            return this.doUpdate(true, true);
        }

        public <R> ExecutableUpdateSupport<S, R> map(QueryResultConverter<? super T, ? extends R> converter) {
            return new ExecutableUpdateSupport<S, R>(this.template, this.domainType, this.query, this.update, this.collection, this.findAndModifyOptions, this.findAndReplaceOptions, this.replacement, this.targetType, this.resultConverter.andThen(converter));
        }

        @Override
        public @Nullable T findAndModifyValue() {
            return this.template.findAndModify(this.query, this.update, this.findAndModifyOptions != null ? this.findAndModifyOptions : new FindAndModifyOptions(), this.targetType, this.getCollectionName(), this.resultConverter);
        }

        @Override
        public @Nullable T findAndReplaceValue() {
            return this.template.findAndReplace(this.query, this.replacement, this.findAndReplaceOptions != null ? this.findAndReplaceOptions : FindAndReplaceOptions.empty(), this.domainType, this.getCollectionName(), this.targetType, this.resultConverter);
        }

        @Override
        public UpdateResult replaceFirst() {
            if (this.replacement != null) {
                return this.template.replace(this.query, this.domainType, this.replacement, this.findAndReplaceOptions != null ? this.findAndReplaceOptions : ReplaceOptions.none(), this.getCollectionName());
            }
            return this.template.replace(this.query, this.domainType, this.update, this.findAndReplaceOptions != null ? this.findAndReplaceOptions : ReplaceOptions.none(), this.getCollectionName());
        }

        private UpdateResult doUpdate(boolean multi, boolean upsert) {
            return this.template.doUpdate(this.getCollectionName(), this.query, this.update, this.domainType, upsert, multi);
        }

        private String getCollectionName() {
            return StringUtils.hasText((String)this.collection) ? this.collection : this.template.getCollectionName(this.domainType);
        }
    }
}

