/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.config;

import org.jspecify.annotations.NullUnmarked;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionValidationException;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.mongodb.config.ConnectionStringPropertyEditor;
import org.springframework.data.mongodb.config.MongoCredentialPropertyEditor;
import org.springframework.data.mongodb.config.ReadConcernPropertyEditor;
import org.springframework.data.mongodb.config.ReadPreferencePropertyEditor;
import org.springframework.data.mongodb.config.UUidRepresentationPropertyEditor;
import org.springframework.data.mongodb.config.WriteConcernPropertyEditor;
import org.springframework.data.mongodb.core.MongoClientSettingsFactoryBean;
import org.springframework.data.mongodb.core.MongoServerApiFactoryBean;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

@NullUnmarked
abstract class MongoParsingUtils {
    private MongoParsingUtils() {
    }

    public static boolean parseMongoClientSettings(Element element, BeanDefinitionBuilder mongoClientBuilder) {
        Element settingsElement = DomUtils.getChildElementByTagName((Element)element, (String)"client-settings");
        if (settingsElement == null) {
            return false;
        }
        BeanDefinitionBuilder clientOptionsDefBuilder = BeanDefinitionBuilder.genericBeanDefinition(MongoClientSettingsFactoryBean.class);
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"application-name", (String)"applicationName");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"read-preference", (String)"readPreference");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"read-concern", (String)"readConcern");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"write-concern", (String)"writeConcern");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"retry-reads", (String)"retryReads");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"retry-writes", (String)"retryWrites");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"uuid-representation", (String)"uUidRepresentation");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"socket-connect-timeout", (String)"socketConnectTimeoutMS");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"socket-read-timeout", (String)"socketReadTimeoutMS");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"socket-receive-buffer-size", (String)"socketReceiveBufferSize");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"socket-send-buffer-size", (String)"socketSendBufferSize");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"server-heartbeat-frequency", (String)"serverHeartbeatFrequencyMS");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"server-min-heartbeat-frequency", (String)"serverMinHeartbeatFrequencyMS");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"cluster-srv-host", (String)"clusterSrvHost");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"cluster-hosts", (String)"clusterHosts");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"cluster-connection-mode", (String)"clusterConnectionMode");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"cluster-type", (String)"custerRequiredClusterType");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"cluster-local-threshold", (String)"clusterLocalThresholdMS");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"cluster-server-selection-timeout", (String)"clusterServerSelectionTimeoutMS");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"connection-pool-max-size", (String)"poolMaxSize");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"connection-pool-min-size", (String)"poolMinSize");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"connection-pool-max-wait-time", (String)"poolMaxWaitTimeMS");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"connection-pool-max-connection-life-time", (String)"poolMaxConnectionLifeTimeMS");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"connection-pool-max-connection-idle-time", (String)"poolMaxConnectionIdleTimeMS");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"connection-pool-maintenance-initial-delay", (String)"poolMaintenanceInitialDelayMS");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"connection-pool-maintenance-frequency", (String)"poolMaintenanceFrequencyMS");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"ssl-enabled", (String)"sslEnabled");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"ssl-invalid-host-name-allowed", (String)"sslInvalidHostNameAllowed");
        ParsingUtils.setPropertyValue((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"ssl-provider", (String)"sslProvider");
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"encryption-settings-ref", (String)"autoEncryptionSettings");
        if (StringUtils.hasText((String)settingsElement.getAttribute("server-api-version"))) {
            MongoServerApiFactoryBean serverApiFactoryBean = new MongoServerApiFactoryBean();
            serverApiFactoryBean.setVersion(settingsElement.getAttribute("server-api-version"));
            try {
                clientOptionsDefBuilder.addPropertyValue("serverApi", (Object)serverApiFactoryBean.getObject());
            }
            catch (Exception exception) {
                throw new BeanDefinitionValidationException("Non parsable server-api.", (Throwable)exception);
            }
        } else {
            ParsingUtils.setPropertyReference((BeanDefinitionBuilder)clientOptionsDefBuilder, (Element)settingsElement, (String)"server-api-ref", (String)"serverApi");
        }
        mongoClientBuilder.addPropertyValue("mongoClientSettings", (Object)clientOptionsDefBuilder.getBeanDefinition());
        return true;
    }

    static BeanDefinitionBuilder getWriteConcernPropertyEditorBuilder() {
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("com.mongodb.WriteConcern", WriteConcernPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", (Object)customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getReadConcernPropertyEditorBuilder() {
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("com.mongodb.ReadConcern", ReadConcernPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", (Object)customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getServerAddressPropertyEditorBuilder() {
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("com.mongodb.ServerAddress[]", "org.springframework.data.mongodb.config.ServerAddressPropertyEditor");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", (Object)customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getReadPreferencePropertyEditorBuilder() {
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("com.mongodb.ReadPreference", ReadPreferencePropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", (Object)customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getMongoCredentialPropertyEditor() {
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("com.mongodb.MongoCredential[]", MongoCredentialPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", (Object)customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getConnectionStringPropertyEditorBuilder() {
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("com.mongodb.ConnectionString", ConnectionStringPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", (Object)customEditors);
        return builder;
    }

    static BeanDefinitionBuilder getUUidRepresentationEditorBuilder() {
        ManagedMap customEditors = new ManagedMap();
        customEditors.put("org.bson.UuidRepresentation", UUidRepresentationPropertyEditor.class);
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(CustomEditorConfigurer.class);
        builder.addPropertyValue("customEditors", (Object)customEditors);
        return builder;
    }
}

