/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import java.util.Arrays;
import org.bson.Document;
import org.bson.codecs.Decoder;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.configuration.CodecRegistry;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.CodecRegistryProvider;
import org.springframework.data.mongodb.MongoExpression;
import org.springframework.data.mongodb.util.json.ParameterBindingDocumentCodec;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class BindableMongoExpression
implements MongoExpression {
    private final String expressionString;
    private final @Nullable CodecRegistryProvider codecRegistryProvider;
    private final Object @Nullable [] args;
    private final Lazy<Document> target;

    public BindableMongoExpression(String expression, Object @Nullable [] args) {
        this(expression, null, args);
    }

    public BindableMongoExpression(String expression, @Nullable CodecRegistryProvider codecRegistryProvider, Object @Nullable [] args) {
        Assert.notNull((Object)expression, (String)"Expression must not be null");
        this.expressionString = expression;
        this.codecRegistryProvider = codecRegistryProvider;
        this.args = args;
        this.target = Lazy.of(this::parse);
    }

    @Contract(value="_ -> new")
    public BindableMongoExpression withCodecRegistry(CodecRegistry codecRegistry) {
        return new BindableMongoExpression(this.expressionString, () -> codecRegistry, this.args);
    }

    @Contract(value="_ -> new")
    public BindableMongoExpression bind(Object ... args) {
        return new BindableMongoExpression(this.expressionString, this.codecRegistryProvider, args);
    }

    @Override
    public Document toDocument() {
        return (Document)this.target.get();
    }

    public String toString() {
        return "BindableMongoExpression{expressionString='" + this.expressionString + "', args=" + Arrays.toString(this.args) + "}";
    }

    private Document parse() {
        String expression = BindableMongoExpression.wrapJsonIfNecessary(this.expressionString);
        if (ObjectUtils.isEmpty((Object[])this.args)) {
            if (this.codecRegistryProvider == null) {
                return Document.parse((String)expression);
            }
            return Document.parse((String)expression, (Decoder)((Decoder)this.codecRegistryProvider.getCodecFor(Document.class).orElseGet(() -> new DocumentCodec(this.codecRegistryProvider.getCodecRegistry()))));
        }
        ParameterBindingDocumentCodec codec = this.codecRegistryProvider == null ? new ParameterBindingDocumentCodec() : new ParameterBindingDocumentCodec(this.codecRegistryProvider.getCodecRegistry());
        return codec.decode(expression, this.args);
    }

    private static String wrapJsonIfNecessary(String json) {
        if (!StringUtils.hasText((String)json)) {
            return json;
        }
        String raw = json.trim();
        return raw.startsWith("{") && raw.endsWith("}") ? raw : "{%s}".formatted(raw);
    }
}

