/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.schema;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.bson.Document;
import org.springframework.data.domain.Range;
import org.springframework.data.mongodb.core.schema.JsonSchemaObject;
import org.springframework.data.mongodb.core.schema.JsonSchemaProperty;
import org.springframework.data.mongodb.core.schema.QueryCharacteristic;
import org.springframework.data.mongodb.core.schema.QueryCharacteristics;
import org.springframework.data.mongodb.core.schema.TypedJsonSchemaObject;
import org.springframework.data.mongodb.core.schema.UntypedJsonSchemaObject;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class IdentifiableJsonSchemaProperty<T extends JsonSchemaObject>
implements JsonSchemaProperty {
    protected final String identifier;
    protected final T jsonSchemaObjectDelegate;

    IdentifiableJsonSchemaProperty(String identifier, T jsonSchemaObject) {
        Assert.notNull((Object)identifier, (String)"Identifier must not be null");
        Assert.notNull(jsonSchemaObject, (String)"JsonSchemaObject must not be null");
        this.identifier = identifier;
        this.jsonSchemaObjectDelegate = jsonSchemaObject;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public Document toDocument() {
        return new Document(this.identifier, (Object)this.jsonSchemaObjectDelegate.toDocument());
    }

    @Override
    public Set<JsonSchemaObject.Type> getTypes() {
        return this.jsonSchemaObjectDelegate.getTypes();
    }

    public static class QueryableJsonSchemaProperty
    implements JsonSchemaProperty {
        private final JsonSchemaProperty targetProperty;
        private final QueryCharacteristics characteristics;

        public QueryableJsonSchemaProperty(JsonSchemaProperty target, QueryCharacteristics characteristics) {
            this.targetProperty = target;
            this.characteristics = characteristics;
        }

        @Override
        public Document toDocument() {
            Document doc = this.targetProperty.toDocument();
            Document propertySpecification = (Document)doc.get((Object)this.targetProperty.getIdentifier(), Document.class);
            if (propertySpecification.containsKey((Object)"encrypt")) {
                Document encrypt = (Document)propertySpecification.get((Object)"encrypt", Document.class);
                List<Document> queries = this.characteristics.getCharacteristics().stream().map(QueryCharacteristic::toDocument).toList();
                encrypt.append("queries", queries);
            }
            return doc;
        }

        @Override
        public String getIdentifier() {
            return this.targetProperty.getIdentifier();
        }

        @Override
        public Set<JsonSchemaObject.Type> getTypes() {
            return this.targetProperty.getTypes();
        }

        boolean isEncrypted() {
            return this.targetProperty instanceof EncryptedJsonSchemaProperty;
        }

        public JsonSchemaProperty getTargetProperty() {
            return this.targetProperty;
        }

        public QueryCharacteristics getCharacteristics() {
            return this.characteristics;
        }
    }

    public static class EncryptedJsonSchemaProperty
    implements JsonSchemaProperty {
        private final JsonSchemaProperty targetProperty;
        @Nullable
        private final String algorithm;
        @Nullable
        private final Object keyId;
        @Nullable
        private final List<?> keyIds;

        public EncryptedJsonSchemaProperty(JsonSchemaProperty target) {
            this(target, null, null, null);
        }

        private EncryptedJsonSchemaProperty(JsonSchemaProperty target, @Nullable String algorithm, @Nullable Object keyId, @Nullable List<?> keyIds) {
            Assert.notNull((Object)target, (String)"Target must not be null");
            this.targetProperty = target;
            this.algorithm = algorithm;
            this.keyId = keyId;
            this.keyIds = keyIds;
        }

        public static EncryptedJsonSchemaProperty encrypted(JsonSchemaProperty target) {
            return new EncryptedJsonSchemaProperty(target);
        }

        public static EncryptedJsonSchemaProperty rangeEncrypted(JsonSchemaProperty target) {
            return new EncryptedJsonSchemaProperty(target).algorithm("Range");
        }

        public EncryptedJsonSchemaProperty aead_aes_256_cbc_hmac_sha_512_random() {
            return this.algorithm("AEAD_AES_256_CBC_HMAC_SHA_512-Random");
        }

        public EncryptedJsonSchemaProperty aead_aes_256_cbc_hmac_sha_512_deterministic() {
            return this.algorithm("AEAD_AES_256_CBC_HMAC_SHA_512-Deterministic");
        }

        public EncryptedJsonSchemaProperty algorithm(String algorithm) {
            return new EncryptedJsonSchemaProperty(this.targetProperty, algorithm, this.keyId, this.keyIds);
        }

        public EncryptedJsonSchemaProperty keyId(String keyId) {
            return new EncryptedJsonSchemaProperty(this.targetProperty, this.algorithm, keyId, null);
        }

        public EncryptedJsonSchemaProperty keyId(Object keyId) {
            return new EncryptedJsonSchemaProperty(this.targetProperty, this.algorithm, keyId, null);
        }

        public EncryptedJsonSchemaProperty keys(UUID ... keyId) {
            return new EncryptedJsonSchemaProperty(this.targetProperty, this.algorithm, null, Arrays.asList(keyId));
        }

        public EncryptedJsonSchemaProperty keys(Object ... keyId) {
            return new EncryptedJsonSchemaProperty(this.targetProperty, this.algorithm, null, Arrays.asList(keyId));
        }

        @Override
        public Document toDocument() {
            Document doc = this.targetProperty.toDocument();
            Document propertySpecification = (Document)doc.get((Object)this.targetProperty.getIdentifier(), Document.class);
            Document enc = new Document();
            if (!ObjectUtils.isEmpty((Object)this.keyId)) {
                enc.append("keyId", this.keyId);
            } else if (!ObjectUtils.isEmpty(this.keyIds)) {
                enc.append("keyId", this.keyIds);
            }
            JsonSchemaObject.Type type = this.extractPropertyType(propertySpecification);
            if (type != null) {
                propertySpecification.remove((Object)type.representation());
                enc.append("bsonType", type.toBsonType().value());
            }
            if (StringUtils.hasText((String)this.algorithm)) {
                enc.append("algorithm", (Object)this.algorithm);
            }
            propertySpecification.append("encrypt", (Object)enc);
            return doc;
        }

        @Override
        public String getIdentifier() {
            return this.targetProperty.getIdentifier();
        }

        @Override
        public Set<JsonSchemaObject.Type> getTypes() {
            return this.targetProperty.getTypes();
        }

        @Nullable
        private JsonSchemaObject.Type extractPropertyType(Document source) {
            if (source.containsKey((Object)"type")) {
                return JsonSchemaObject.Type.of((String)source.get((Object)"type", String.class));
            }
            if (source.containsKey((Object)"bsonType")) {
                return JsonSchemaObject.Type.of((String)source.get((Object)"bsonType", String.class));
            }
            return null;
        }

        public Object getKeyId() {
            if (this.keyId != null) {
                return this.keyId;
            }
            if (this.keyIds != null && this.keyIds.size() == 1) {
                return this.keyIds.iterator().next();
            }
            return null;
        }
    }

    public static class RequiredJsonSchemaProperty
    implements JsonSchemaProperty {
        private final JsonSchemaProperty delegate;
        private final boolean required;

        RequiredJsonSchemaProperty(JsonSchemaProperty delegate, boolean required) {
            this.delegate = delegate;
            this.required = required;
        }

        @Override
        public String getIdentifier() {
            return this.delegate.getIdentifier();
        }

        @Override
        public Set<JsonSchemaObject.Type> getTypes() {
            return this.delegate.getTypes();
        }

        @Override
        public Document toDocument() {
            return this.delegate.toDocument();
        }

        @Override
        public boolean isRequired() {
            return this.required;
        }
    }

    public static class TimestampJsonSchemaProperty
    extends IdentifiableJsonSchemaProperty<TypedJsonSchemaObject.TimestampJsonSchemaObject> {
        TimestampJsonSchemaProperty(String identifier, TypedJsonSchemaObject.TimestampJsonSchemaObject schemaObject) {
            super(identifier, schemaObject);
        }

        public TimestampJsonSchemaProperty description(String description) {
            return new TimestampJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.TimestampJsonSchemaObject)this.jsonSchemaObjectDelegate).description(description));
        }

        public TimestampJsonSchemaProperty generatedDescription() {
            return new TimestampJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.TimestampJsonSchemaObject)this.jsonSchemaObjectDelegate).generatedDescription());
        }
    }

    public static class DateJsonSchemaProperty
    extends IdentifiableJsonSchemaProperty<TypedJsonSchemaObject.DateJsonSchemaObject> {
        DateJsonSchemaProperty(String identifier, TypedJsonSchemaObject.DateJsonSchemaObject schemaObject) {
            super(identifier, schemaObject);
        }

        public DateJsonSchemaProperty description(String description) {
            return new DateJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.DateJsonSchemaObject)this.jsonSchemaObjectDelegate).description(description));
        }

        public DateJsonSchemaProperty generatedDescription() {
            return new DateJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.DateJsonSchemaObject)this.jsonSchemaObjectDelegate).generatedDescription());
        }
    }

    public static class NullJsonSchemaProperty
    extends IdentifiableJsonSchemaProperty<TypedJsonSchemaObject.NullJsonSchemaObject> {
        NullJsonSchemaProperty(String identifier, TypedJsonSchemaObject.NullJsonSchemaObject schemaObject) {
            super(identifier, schemaObject);
        }

        public NullJsonSchemaProperty description(String description) {
            return new NullJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.NullJsonSchemaObject)this.jsonSchemaObjectDelegate).description(description));
        }

        public NullJsonSchemaProperty generatedDescription() {
            return new NullJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.NullJsonSchemaObject)this.jsonSchemaObjectDelegate).generatedDescription());
        }
    }

    public static class BooleanJsonSchemaProperty
    extends IdentifiableJsonSchemaProperty<TypedJsonSchemaObject.BooleanJsonSchemaObject> {
        BooleanJsonSchemaProperty(String identifier, TypedJsonSchemaObject.BooleanJsonSchemaObject schemaObject) {
            super(identifier, schemaObject);
        }

        public BooleanJsonSchemaProperty description(String description) {
            return new BooleanJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.BooleanJsonSchemaObject)this.jsonSchemaObjectDelegate).description(description));
        }

        public BooleanJsonSchemaProperty generatedDescription() {
            return new BooleanJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.BooleanJsonSchemaObject)this.jsonSchemaObjectDelegate).generatedDescription());
        }
    }

    public static class ArrayJsonSchemaProperty
    extends IdentifiableJsonSchemaProperty<TypedJsonSchemaObject.ArrayJsonSchemaObject> {
        public ArrayJsonSchemaProperty(String identifier, TypedJsonSchemaObject.ArrayJsonSchemaObject schemaObject) {
            super(identifier, schemaObject);
        }

        public ArrayJsonSchemaProperty uniqueItems(boolean uniqueItems) {
            return new ArrayJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).uniqueItems(uniqueItems));
        }

        public ArrayJsonSchemaProperty range(Range<Integer> range) {
            return new ArrayJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).range(range));
        }

        public ArrayJsonSchemaProperty minItems(int count) {
            return new ArrayJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).minItems(count));
        }

        public ArrayJsonSchemaProperty maxItems(int count) {
            return new ArrayJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).maxItems(count));
        }

        public ArrayJsonSchemaProperty items(JsonSchemaObject ... items) {
            return new ArrayJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).items(Arrays.asList(items)));
        }

        public ArrayJsonSchemaProperty items(Collection<JsonSchemaObject> items) {
            return new ArrayJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).items(items));
        }

        public ArrayJsonSchemaProperty additionalItems(boolean additionalItemsAllowed) {
            return new ArrayJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).additionalItems(additionalItemsAllowed));
        }

        public ArrayJsonSchemaProperty possibleValues(Object ... possibleValues) {
            return this.possibleValues(new LinkedHashSet<Object>(Arrays.asList(possibleValues)));
        }

        public ArrayJsonSchemaProperty allOf(JsonSchemaObject ... allOf) {
            return this.allOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(allOf)));
        }

        public ArrayJsonSchemaProperty anyOf(JsonSchemaObject ... anyOf) {
            return this.anyOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(anyOf)));
        }

        public ArrayJsonSchemaProperty oneOf(JsonSchemaObject ... oneOf) {
            return this.oneOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(oneOf)));
        }

        public ArrayJsonSchemaProperty possibleValues(Collection<Object> possibleValues) {
            return new ArrayJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.ArrayJsonSchemaObject)((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).possibleValues(possibleValues));
        }

        public ArrayJsonSchemaProperty allOf(Collection<JsonSchemaObject> allOf) {
            return new ArrayJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.ArrayJsonSchemaObject)((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).allOf((Collection)allOf));
        }

        public ArrayJsonSchemaProperty anyOf(Collection<JsonSchemaObject> anyOf) {
            return new ArrayJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.ArrayJsonSchemaObject)((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).anyOf((Collection)anyOf));
        }

        public ArrayJsonSchemaProperty oneOf(Collection<JsonSchemaObject> oneOf) {
            return new ArrayJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.ArrayJsonSchemaObject)((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).oneOf((Collection)oneOf));
        }

        public ArrayJsonSchemaProperty notMatch(JsonSchemaObject notMatch) {
            return new ArrayJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).notMatch(notMatch));
        }

        public ArrayJsonSchemaProperty description(String description) {
            return new ArrayJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).description(description));
        }

        public ArrayJsonSchemaProperty generatedDescription() {
            return new ArrayJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ArrayJsonSchemaObject)this.jsonSchemaObjectDelegate).generatedDescription());
        }
    }

    public static class NumericJsonSchemaProperty
    extends IdentifiableJsonSchemaProperty<TypedJsonSchemaObject.NumericJsonSchemaObject> {
        public NumericJsonSchemaProperty(String identifier, TypedJsonSchemaObject.NumericJsonSchemaObject schemaObject) {
            super(identifier, schemaObject);
        }

        public NumericJsonSchemaProperty multipleOf(Number value) {
            return new NumericJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.NumericJsonSchemaObject)this.jsonSchemaObjectDelegate).multipleOf(value));
        }

        public NumericJsonSchemaProperty within(Range<? extends Number> range) {
            return new NumericJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.NumericJsonSchemaObject)this.jsonSchemaObjectDelegate).within(range));
        }

        public NumericJsonSchemaProperty gt(Number min) {
            return new NumericJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.NumericJsonSchemaObject)this.jsonSchemaObjectDelegate).gt(min));
        }

        public NumericJsonSchemaProperty gte(Number min) {
            return new NumericJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.NumericJsonSchemaObject)this.jsonSchemaObjectDelegate).gte(min));
        }

        public NumericJsonSchemaProperty lt(Number max) {
            return new NumericJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.NumericJsonSchemaObject)this.jsonSchemaObjectDelegate).lt(max));
        }

        public NumericJsonSchemaProperty lte(Number max) {
            return new NumericJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.NumericJsonSchemaObject)this.jsonSchemaObjectDelegate).lte(max));
        }

        public NumericJsonSchemaProperty possibleValues(Number ... possibleValues) {
            return this.possibleValues(new LinkedHashSet<Number>(Arrays.asList(possibleValues)));
        }

        public NumericJsonSchemaProperty allOf(JsonSchemaObject ... allOf) {
            return this.allOf(Arrays.asList(allOf));
        }

        public NumericJsonSchemaProperty anyOf(JsonSchemaObject ... anyOf) {
            return this.anyOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(anyOf)));
        }

        public NumericJsonSchemaProperty oneOf(JsonSchemaObject ... oneOf) {
            return this.oneOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(oneOf)));
        }

        public NumericJsonSchemaProperty possibleValues(Collection<Number> possibleValues) {
            return new NumericJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.NumericJsonSchemaObject)((TypedJsonSchemaObject.NumericJsonSchemaObject)this.jsonSchemaObjectDelegate).possibleValues(possibleValues));
        }

        public NumericJsonSchemaProperty allOf(Collection<JsonSchemaObject> allOf) {
            return new NumericJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.NumericJsonSchemaObject)((TypedJsonSchemaObject.NumericJsonSchemaObject)this.jsonSchemaObjectDelegate).allOf((Collection)allOf));
        }

        public NumericJsonSchemaProperty anyOf(Collection<JsonSchemaObject> anyOf) {
            return new NumericJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.NumericJsonSchemaObject)((TypedJsonSchemaObject.NumericJsonSchemaObject)this.jsonSchemaObjectDelegate).anyOf((Collection)anyOf));
        }

        public NumericJsonSchemaProperty oneOf(Collection<JsonSchemaObject> oneOf) {
            return new NumericJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.NumericJsonSchemaObject)((TypedJsonSchemaObject.NumericJsonSchemaObject)this.jsonSchemaObjectDelegate).oneOf((Collection)oneOf));
        }

        public NumericJsonSchemaProperty notMatch(JsonSchemaObject notMatch) {
            return new NumericJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.NumericJsonSchemaObject)this.jsonSchemaObjectDelegate).notMatch(notMatch));
        }

        public NumericJsonSchemaProperty description(String description) {
            return new NumericJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.NumericJsonSchemaObject)this.jsonSchemaObjectDelegate).description(description));
        }

        public NumericJsonSchemaProperty generatedDescription() {
            return new NumericJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.NumericJsonSchemaObject)this.jsonSchemaObjectDelegate).generatedDescription());
        }
    }

    public static class ObjectJsonSchemaProperty
    extends IdentifiableJsonSchemaProperty<TypedJsonSchemaObject.ObjectJsonSchemaObject> {
        ObjectJsonSchemaProperty(String identifier, TypedJsonSchemaObject.ObjectJsonSchemaObject schemaObject) {
            super(identifier, schemaObject);
        }

        public ObjectJsonSchemaProperty propertiesCount(Range<Integer> range) {
            return new ObjectJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).propertiesCount(range));
        }

        public ObjectJsonSchemaProperty minProperties(int count) {
            return new ObjectJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).minProperties(count));
        }

        public ObjectJsonSchemaProperty maxProperties(int count) {
            return new ObjectJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).maxProperties(count));
        }

        public ObjectJsonSchemaProperty required(String ... properties) {
            return new ObjectJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).required(properties));
        }

        public ObjectJsonSchemaProperty additionalProperties(boolean additionalPropertiesAllowed) {
            return new ObjectJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).additionalProperties(additionalPropertiesAllowed));
        }

        public ObjectJsonSchemaProperty additionalProperties(TypedJsonSchemaObject.ObjectJsonSchemaObject additionalProperties) {
            return new ObjectJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).additionalProperties(additionalProperties));
        }

        public ObjectJsonSchemaProperty properties(JsonSchemaProperty ... properties) {
            return new ObjectJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).properties(properties));
        }

        public ObjectJsonSchemaProperty possibleValues(Object ... possibleValues) {
            return this.possibleValues(Arrays.asList(possibleValues));
        }

        public ObjectJsonSchemaProperty allOf(JsonSchemaObject ... allOf) {
            return this.allOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(allOf)));
        }

        public ObjectJsonSchemaProperty anyOf(JsonSchemaObject ... anyOf) {
            return this.anyOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(anyOf)));
        }

        public ObjectJsonSchemaProperty oneOf(JsonSchemaObject ... oneOf) {
            return this.oneOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(oneOf)));
        }

        public ObjectJsonSchemaProperty possibleValues(Collection<Object> possibleValues) {
            return new ObjectJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.ObjectJsonSchemaObject)((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).possibleValues(possibleValues));
        }

        public ObjectJsonSchemaProperty allOf(Collection<JsonSchemaObject> allOf) {
            return new ObjectJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.ObjectJsonSchemaObject)((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).allOf((Collection)allOf));
        }

        public ObjectJsonSchemaProperty anyOf(Collection<JsonSchemaObject> anyOf) {
            return new ObjectJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.ObjectJsonSchemaObject)((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).anyOf((Collection)anyOf));
        }

        public ObjectJsonSchemaProperty oneOf(Collection<JsonSchemaObject> oneOf) {
            return new ObjectJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.ObjectJsonSchemaObject)((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).oneOf((Collection)oneOf));
        }

        public ObjectJsonSchemaProperty notMatch(JsonSchemaObject notMatch) {
            return new ObjectJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).notMatch(notMatch));
        }

        public ObjectJsonSchemaProperty description(String description) {
            return new ObjectJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).description(description));
        }

        public ObjectJsonSchemaProperty generatedDescription() {
            return new ObjectJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).generatedDescription());
        }

        public List<JsonSchemaProperty> getProperties() {
            return ((TypedJsonSchemaObject.ObjectJsonSchemaObject)this.jsonSchemaObjectDelegate).getProperties();
        }
    }

    public static class StringJsonSchemaProperty
    extends IdentifiableJsonSchemaProperty<TypedJsonSchemaObject.StringJsonSchemaObject> {
        StringJsonSchemaProperty(String identifier, TypedJsonSchemaObject.StringJsonSchemaObject schemaObject) {
            super(identifier, schemaObject);
        }

        public StringJsonSchemaProperty minLength(int length) {
            return new StringJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.StringJsonSchemaObject)this.jsonSchemaObjectDelegate).minLength(length));
        }

        public StringJsonSchemaProperty maxLength(int length) {
            return new StringJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.StringJsonSchemaObject)this.jsonSchemaObjectDelegate).maxLength(length));
        }

        public StringJsonSchemaProperty matching(String pattern) {
            return new StringJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.StringJsonSchemaObject)this.jsonSchemaObjectDelegate).matching(pattern));
        }

        public StringJsonSchemaProperty possibleValues(String ... possibleValues) {
            return this.possibleValues(Arrays.asList(possibleValues));
        }

        public StringJsonSchemaProperty allOf(JsonSchemaObject ... allOf) {
            return this.allOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(allOf)));
        }

        public StringJsonSchemaProperty anyOf(JsonSchemaObject ... anyOf) {
            return this.anyOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(anyOf)));
        }

        public StringJsonSchemaProperty oneOf(JsonSchemaObject ... oneOf) {
            return this.oneOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(oneOf)));
        }

        public StringJsonSchemaProperty possibleValues(Collection<String> possibleValues) {
            return new StringJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.StringJsonSchemaObject)((TypedJsonSchemaObject.StringJsonSchemaObject)this.jsonSchemaObjectDelegate).possibleValues(possibleValues));
        }

        public StringJsonSchemaProperty allOf(Collection<JsonSchemaObject> allOf) {
            return new StringJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.StringJsonSchemaObject)((TypedJsonSchemaObject.StringJsonSchemaObject)this.jsonSchemaObjectDelegate).allOf((Collection)allOf));
        }

        public StringJsonSchemaProperty anyOf(Collection<JsonSchemaObject> anyOf) {
            return new StringJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.StringJsonSchemaObject)((TypedJsonSchemaObject.StringJsonSchemaObject)this.jsonSchemaObjectDelegate).anyOf((Collection)anyOf));
        }

        public StringJsonSchemaProperty oneOf(Collection<JsonSchemaObject> oneOf) {
            return new StringJsonSchemaProperty(this.identifier, (TypedJsonSchemaObject.StringJsonSchemaObject)((TypedJsonSchemaObject.StringJsonSchemaObject)this.jsonSchemaObjectDelegate).oneOf((Collection)oneOf));
        }

        public StringJsonSchemaProperty notMatch(JsonSchemaObject notMatch) {
            return new StringJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.StringJsonSchemaObject)this.jsonSchemaObjectDelegate).notMatch(notMatch));
        }

        public StringJsonSchemaProperty description(String description) {
            return new StringJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.StringJsonSchemaObject)this.jsonSchemaObjectDelegate).description(description));
        }

        public StringJsonSchemaProperty generatedDescription() {
            return new StringJsonSchemaProperty(this.identifier, ((TypedJsonSchemaObject.StringJsonSchemaObject)this.jsonSchemaObjectDelegate).generatedDescription());
        }
    }

    public static class UntypedJsonSchemaProperty
    extends IdentifiableJsonSchemaProperty<UntypedJsonSchemaObject> {
        UntypedJsonSchemaProperty(String identifier, UntypedJsonSchemaObject jsonSchemaObject) {
            super(identifier, jsonSchemaObject);
        }

        public UntypedJsonSchemaProperty possibleValues(Object ... possibleValues) {
            return this.possibleValues(Arrays.asList(possibleValues));
        }

        public UntypedJsonSchemaProperty allOf(JsonSchemaObject ... allOf) {
            return this.allOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(allOf)));
        }

        public UntypedJsonSchemaProperty anyOf(JsonSchemaObject ... anyOf) {
            return this.anyOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(anyOf)));
        }

        public UntypedJsonSchemaProperty oneOf(JsonSchemaObject ... oneOf) {
            return this.oneOf(new LinkedHashSet<JsonSchemaObject>(Arrays.asList(oneOf)));
        }

        public UntypedJsonSchemaProperty possibleValues(Collection<Object> possibleValues) {
            return new UntypedJsonSchemaProperty(this.identifier, ((UntypedJsonSchemaObject)this.jsonSchemaObjectDelegate).possibleValues(possibleValues));
        }

        public UntypedJsonSchemaProperty allOf(Collection<JsonSchemaObject> allOf) {
            return new UntypedJsonSchemaProperty(this.identifier, ((UntypedJsonSchemaObject)this.jsonSchemaObjectDelegate).allOf(allOf));
        }

        public UntypedJsonSchemaProperty anyOf(Collection<JsonSchemaObject> anyOf) {
            return new UntypedJsonSchemaProperty(this.identifier, ((UntypedJsonSchemaObject)this.jsonSchemaObjectDelegate).anyOf(anyOf));
        }

        public UntypedJsonSchemaProperty oneOf(Collection<JsonSchemaObject> oneOf) {
            return new UntypedJsonSchemaProperty(this.identifier, ((UntypedJsonSchemaObject)this.jsonSchemaObjectDelegate).oneOf(oneOf));
        }

        public UntypedJsonSchemaProperty notMatch(JsonSchemaObject notMatch) {
            return new UntypedJsonSchemaProperty(this.identifier, ((UntypedJsonSchemaObject)this.jsonSchemaObjectDelegate).notMatch(notMatch));
        }

        public UntypedJsonSchemaProperty description(String description) {
            return new UntypedJsonSchemaProperty(this.identifier, ((UntypedJsonSchemaObject)this.jsonSchemaObjectDelegate).description(description));
        }

        public UntypedJsonSchemaProperty generatedDescription() {
            return new UntypedJsonSchemaProperty(this.identifier, ((UntypedJsonSchemaObject)this.jsonSchemaObjectDelegate).generatedDescription());
        }
    }
}

