/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.util;

import com.mongodb.MongoClientSettings;
import com.mongodb.ServerAddress;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.vault.RangeOptions;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.MapReducePublisher;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.data.mongodb.util.MongoClientVersion;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class MongoCompatibilityAdapter {
    private static final String NO_LONGER_SUPPORTED = "%s is no longer supported on Mongo Client 5 or newer";
    private static final String NOT_SUPPORTED_ON_4 = "%s is not supported on Mongo Client 4";
    @Nullable
    private static final Method getStreamFactoryFactory = ReflectionUtils.findMethod(MongoClientSettings.class, (String)"getStreamFactoryFactory");
    @Nullable
    private static final Method setBucketSize = ReflectionUtils.findMethod(IndexOptions.class, (String)"bucketSize", (Class[])new Class[]{Double.class});
    @Nullable
    private static final Method setTrimFactor;

    public static ClientSettingsBuilderAdapter clientSettingsBuilderAdapter(MongoClientSettings.Builder builder) {
        return new MongoStreamFactoryFactorySettingsConfigurer(builder)::setStreamFactory;
    }

    public static ClientSettingsAdapter clientSettingsAdapter(final MongoClientSettings clientSettings) {
        return new ClientSettingsAdapter(){

            @Override
            public <T> T getStreamFactoryFactory() {
                if (MongoClientVersion.isVersion5orNewer() || getStreamFactoryFactory == null) {
                    return null;
                }
                return (T)ReflectionUtils.invokeMethod((Method)getStreamFactoryFactory, (Object)clientSettings);
            }
        };
    }

    public static IndexOptionsAdapter indexOptionsAdapter(IndexOptions options) {
        return bucketSize -> {
            if (MongoClientVersion.isVersion5orNewer() || setBucketSize == null) {
                throw new UnsupportedOperationException(NO_LONGER_SUPPORTED.formatted("IndexOptions.bucketSize"));
            }
            ReflectionUtils.invokeMethod((Method)setBucketSize, (Object)options, (Object[])new Object[]{bucketSize});
        };
    }

    public static MapReduceIterableAdapter mapReduceIterableAdapter(Object iterable) {
        return sharded -> {
            if (MongoClientVersion.isVersion5orNewer()) {
                throw new UnsupportedOperationException(NO_LONGER_SUPPORTED.formatted("sharded"));
            }
            Method shardedMethod = ReflectionUtils.findMethod(MapReduceIterable.class, (String)"sharded", (Class[])new Class[]{Boolean.TYPE});
            ReflectionUtils.invokeMethod((Method)shardedMethod, (Object)iterable, (Object[])new Object[]{sharded});
        };
    }

    public static RangeOptionsAdapter rangeOptionsAdapter(RangeOptions options) {
        return trimFactor -> {
            if (!MongoClientVersion.isVersion5orNewer() || setTrimFactor == null) {
                throw new UnsupportedOperationException(NOT_SUPPORTED_ON_4.formatted("RangeOptions.trimFactor"));
            }
            ReflectionUtils.invokeMethod((Method)setTrimFactor, (Object)options, (Object[])new Object[]{trimFactor});
        };
    }

    public static MapReducePublisherAdapter mapReducePublisherAdapter(Object publisher) {
        return sharded -> {
            if (MongoClientVersion.isVersion5orNewer()) {
                throw new UnsupportedOperationException(NO_LONGER_SUPPORTED.formatted("sharded"));
            }
            Method shardedMethod = ReflectionUtils.findMethod(MapReducePublisher.class, (String)"sharded", (Class[])new Class[]{Boolean.TYPE});
            ReflectionUtils.invokeMethod((Method)shardedMethod, (Object)publisher, (Object[])new Object[]{sharded});
        };
    }

    public static ServerAddressAdapter serverAddressAdapter(ServerAddress serverAddress) {
        return () -> {
            if (MongoClientVersion.isVersion5orNewer()) {
                return null;
            }
            Method serverAddressMethod = ReflectionUtils.findMethod(ServerAddress.class, (String)"getSocketAddress");
            Object value = ReflectionUtils.invokeMethod((Method)serverAddressMethod, (Object)serverAddress);
            return value != null ? (InetSocketAddress)InetSocketAddress.class.cast(value) : null;
        };
    }

    public static MongoDatabaseAdapterBuilder mongoDatabaseAdapter() {
        return MongoDatabaseAdapter::new;
    }

    public static ReactiveMongoDatabaseAdapterBuilder reactiveMongoDatabaseAdapter() {
        return ReactiveMongoDatabaseAdapter::new;
    }

    static {
        Method trimFactor = ReflectionUtils.findMethod(RangeOptions.class, (String)"setTrimFactor", (Class[])new Class[]{Integer.class});
        setTrimFactor = trimFactor != null ? trimFactor : ReflectionUtils.findMethod(RangeOptions.class, (String)"trimFactor", (Class[])new Class[]{Integer.class});
    }

    static class MongoStreamFactoryFactorySettingsConfigurer {
        private static final Log logger = LogFactory.getLog(MongoStreamFactoryFactorySettingsConfigurer.class);
        private static final String STREAM_FACTORY_NAME = "com.mongodb.connection.StreamFactoryFactory";
        private static final boolean STREAM_FACTORY_PRESENT = ClassUtils.isPresent((String)"com.mongodb.connection.StreamFactoryFactory", (ClassLoader)MongoCompatibilityAdapter.class.getClassLoader());
        private final MongoClientSettings.Builder settingsBuilder;

        static boolean isStreamFactoryPresent() {
            return STREAM_FACTORY_PRESENT;
        }

        public MongoStreamFactoryFactorySettingsConfigurer(MongoClientSettings.Builder settingsBuilder) {
            this.settingsBuilder = settingsBuilder;
        }

        void setStreamFactory(Object streamFactory) {
            if (MongoClientVersion.isVersion5orNewer() && MongoStreamFactoryFactorySettingsConfigurer.isStreamFactoryPresent()) {
                logger.warn((Object)"StreamFactoryFactory is no longer available. Use TransportSettings instead.");
                return;
            }
            try {
                Class streamFactoryType = ClassUtils.forName((String)STREAM_FACTORY_NAME, (ClassLoader)streamFactory.getClass().getClassLoader());
                if (!ClassUtils.isAssignable((Class)streamFactoryType, streamFactory.getClass())) {
                    throw new IllegalArgumentException("Expected %s but found %s".formatted(streamFactoryType, streamFactory));
                }
                Method setter = ReflectionUtils.findMethod(this.settingsBuilder.getClass(), (String)"streamFactoryFactory", (Class[])new Class[]{streamFactoryType});
                if (setter != null) {
                    ReflectionUtils.invokeMethod((Method)setter, (Object)this.settingsBuilder, (Object[])new Object[]{streamFactoryType.cast(streamFactory)});
                }
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalArgumentException("Cannot set StreamFactoryFactory for %s".formatted(this.settingsBuilder), e);
            }
        }
    }

    public static interface ClientSettingsBuilderAdapter {
        public <T> void setStreamFactoryFactory(T var1);
    }

    public static interface IndexOptionsAdapter {
        public void setBucketSize(double var1);
    }

    public static interface MapReduceIterableAdapter {
        public void sharded(boolean var1);
    }

    public static interface RangeOptionsAdapter {
        public void trimFactor(Integer var1);
    }

    public static interface MapReducePublisherAdapter {
        public void sharded(boolean var1);
    }

    public static interface ServerAddressAdapter {
        @Nullable
        public InetSocketAddress getSocketAddress();
    }

    public static interface MongoDatabaseAdapterBuilder {
        public MongoDatabaseAdapter forDb(MongoDatabase var1);
    }

    public static interface ReactiveMongoDatabaseAdapterBuilder {
        public ReactiveMongoDatabaseAdapter forDb(com.mongodb.reactivestreams.client.MongoDatabase var1);
    }

    public static class ReactiveMongoDatabaseAdapter {
        @Nullable
        private static final Method LIST_COLLECTION_NAMES_METHOD;
        @Nullable
        private static final Method LIST_COLLECTION_NAMES_METHOD_SESSION;
        private static final Class<?> collectionNamesReturnType;
        private final com.mongodb.reactivestreams.client.MongoDatabase db;

        ReactiveMongoDatabaseAdapter(com.mongodb.reactivestreams.client.MongoDatabase db) {
            this.db = db;
        }

        public Class<? extends Publisher<String>> collectionNamePublisherType() {
            return collectionNamesReturnType;
        }

        public Publisher<String> listCollectionNames() {
            Assert.state((LIST_COLLECTION_NAMES_METHOD != null ? 1 : 0) != 0, (String)"No method listCollectionNames present for %s".formatted(this.db));
            return (Publisher)ReflectionUtils.invokeMethod((Method)LIST_COLLECTION_NAMES_METHOD, (Object)this.db);
        }

        public Publisher<String> listCollectionNames(ClientSession clientSession) {
            Assert.state((LIST_COLLECTION_NAMES_METHOD != null ? 1 : 0) != 0, (String)"No method listCollectionNames(ClientSession) present for %s".formatted(this.db));
            return (Publisher)ReflectionUtils.invokeMethod((Method)LIST_COLLECTION_NAMES_METHOD_SESSION, (Object)this.db, (Object[])new Object[]{clientSession});
        }

        static {
            if (MongoClientVersion.isReactiveClientPresent()) {
                LIST_COLLECTION_NAMES_METHOD = ReflectionUtils.findMethod(com.mongodb.reactivestreams.client.MongoDatabase.class, (String)"listCollectionNames");
                LIST_COLLECTION_NAMES_METHOD_SESSION = ReflectionUtils.findMethod(com.mongodb.reactivestreams.client.MongoDatabase.class, (String)"listCollectionNames", (Class[])new Class[]{ClientSession.class});
                if (MongoClientVersion.isVersion5orNewer()) {
                    try {
                        collectionNamesReturnType = ClassUtils.forName((String)"com.mongodb.reactivestreams.client.ListCollectionNamesPublisher", (ClassLoader)ReactiveMongoDatabaseAdapter.class.getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("com.mongodb.reactivestreams.client.ListCollectionNamesPublisher", e);
                    }
                } else {
                    try {
                        collectionNamesReturnType = ClassUtils.forName((String)"org.reactivestreams.Publisher", (ClassLoader)ReactiveMongoDatabaseAdapter.class.getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("org.reactivestreams.Publisher", e);
                    }
                }
            } else {
                LIST_COLLECTION_NAMES_METHOD = null;
                LIST_COLLECTION_NAMES_METHOD_SESSION = null;
                collectionNamesReturnType = Object.class;
            }
        }
    }

    public static class MongoDatabaseAdapter {
        @Nullable
        private static final Method LIST_COLLECTION_NAMES_METHOD;
        @Nullable
        private static final Method LIST_COLLECTION_NAMES_METHOD_SESSION;
        private static final Class<?> collectionNamesReturnType;
        private final MongoDatabase db;

        public MongoDatabaseAdapter(MongoDatabase db) {
            this.db = db;
        }

        public Class<? extends MongoIterable<String>> collectionNameIterableType() {
            return collectionNamesReturnType;
        }

        public MongoIterable<String> listCollectionNames() {
            Assert.state((LIST_COLLECTION_NAMES_METHOD != null ? 1 : 0) != 0, (String)"No method listCollectionNames present for %s".formatted(this.db));
            return (MongoIterable)ReflectionUtils.invokeMethod((Method)LIST_COLLECTION_NAMES_METHOD, (Object)this.db);
        }

        public MongoIterable<String> listCollectionNames(com.mongodb.client.ClientSession clientSession) {
            Assert.state((LIST_COLLECTION_NAMES_METHOD != null ? 1 : 0) != 0, (String)"No method listCollectionNames(ClientSession) present for %s".formatted(this.db));
            return (MongoIterable)ReflectionUtils.invokeMethod((Method)LIST_COLLECTION_NAMES_METHOD_SESSION, (Object)this.db, (Object[])new Object[]{clientSession});
        }

        static {
            if (MongoClientVersion.isSyncClientPresent()) {
                LIST_COLLECTION_NAMES_METHOD = ReflectionUtils.findMethod(MongoDatabase.class, (String)"listCollectionNames");
                LIST_COLLECTION_NAMES_METHOD_SESSION = ReflectionUtils.findMethod(MongoDatabase.class, (String)"listCollectionNames", (Class[])new Class[]{com.mongodb.client.ClientSession.class});
                if (MongoClientVersion.isVersion5orNewer()) {
                    try {
                        collectionNamesReturnType = ClassUtils.forName((String)"com.mongodb.client.ListCollectionNamesIterable", (ClassLoader)MongoDatabaseAdapter.class.getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Unable to load com.mongodb.client.ListCollectionNamesIterable", e);
                    }
                } else {
                    try {
                        collectionNamesReturnType = ClassUtils.forName((String)"com.mongodb.client.MongoIterable", (ClassLoader)MongoDatabaseAdapter.class.getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Unable to load com.mongodb.client.ListCollectionNamesIterable", e);
                    }
                }
            } else {
                LIST_COLLECTION_NAMES_METHOD = null;
                LIST_COLLECTION_NAMES_METHOD_SESSION = null;
                collectionNamesReturnType = Object.class;
            }
        }
    }

    public static interface ClientSettingsAdapter {
        @Nullable
        public <T> T getStreamFactoryFactory();
    }
}

