/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.mapping;

import org.bson.BinaryVector;
import org.bson.Float32BinaryVector;
import org.bson.Int8BinaryVector;
import org.bson.PackedBitBinaryVector;
import org.springframework.data.domain.Vector;
import org.springframework.util.ObjectUtils;

public class MongoVector
implements Vector {
    private final BinaryVector v;

    MongoVector(BinaryVector v) {
        this.v = v;
    }

    public static MongoVector of(BinaryVector v) {
        return new MongoVector(v);
    }

    public static MongoVector ofInt8(byte[] data) {
        return MongoVector.of((BinaryVector)BinaryVector.int8Vector((byte[])data));
    }

    public static MongoVector ofFloat(float ... data) {
        return MongoVector.of((BinaryVector)BinaryVector.floatVector((float[])data));
    }

    public static MongoVector fromFloat(Vector v) {
        return MongoVector.of((BinaryVector)BinaryVector.floatVector((float[])v.toFloatArray()));
    }

    public Class<? extends Number> getType() {
        if (this.v instanceof Float32BinaryVector) {
            return Float.class;
        }
        if (this.v instanceof Int8BinaryVector) {
            return Byte.class;
        }
        if (this.v instanceof PackedBitBinaryVector) {
            return Byte.class;
        }
        return Number.class;
    }

    public BinaryVector getSource() {
        return this.v;
    }

    public int size() {
        BinaryVector binaryVector = this.v;
        if (binaryVector instanceof Float32BinaryVector) {
            Float32BinaryVector f = (Float32BinaryVector)binaryVector;
            return f.getData().length;
        }
        binaryVector = this.v;
        if (binaryVector instanceof Int8BinaryVector) {
            Int8BinaryVector i = (Int8BinaryVector)binaryVector;
            return i.getData().length;
        }
        binaryVector = this.v;
        if (binaryVector instanceof PackedBitBinaryVector) {
            PackedBitBinaryVector p = (PackedBitBinaryVector)binaryVector;
            return p.getData().length;
        }
        return 0;
    }

    public float[] toFloatArray() {
        Object result;
        BinaryVector binaryVector = this.v;
        if (binaryVector instanceof Float32BinaryVector) {
            Float32BinaryVector f = (Float32BinaryVector)binaryVector;
            result = new float[f.getData().length];
            System.arraycopy(f.getData(), 0, result, 0, ((BinaryVector)result).length);
            return result;
        }
        result = this.v;
        if (result instanceof Int8BinaryVector) {
            Int8BinaryVector i = (Int8BinaryVector)result;
            byte[] data = i.getData();
            float[] result2 = new float[data.length];
            for (int j = 0; j < data.length; ++j) {
                result2[j] = data[j];
            }
            return result2;
        }
        throw new UnsupportedOperationException("Cannot return float array for " + String.valueOf(this.v.getClass()));
    }

    public double[] toDoubleArray() {
        Object data;
        BinaryVector binaryVector = this.v;
        if (binaryVector instanceof Float32BinaryVector) {
            Float32BinaryVector f = (Float32BinaryVector)binaryVector;
            data = f.getData();
            double[] result = new double[((BinaryVector)data).length];
            for (int i = 0; i < ((BinaryVector)data).length; ++i) {
                result[i] = (double)data[i];
            }
            return result;
        }
        data = this.v;
        if (data instanceof Int8BinaryVector) {
            Int8BinaryVector i = (Int8BinaryVector)data;
            data = i.getData();
            double[] result = new double[((BinaryVector)data).length];
            for (int j = 0; j < ((BinaryVector)data).length; ++j) {
                result[j] = (double)data[j];
            }
            return result;
        }
        throw new UnsupportedOperationException("Cannot return double array for " + String.valueOf(this.v.getClass()));
    }

    public boolean equals(Object o) {
        if (!(o instanceof MongoVector)) {
            return false;
        }
        MongoVector that = (MongoVector)o;
        return ObjectUtils.nullSafeEquals((Object)this.v, (Object)that.v);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object)this.v);
    }

    public String toString() {
        return "MV[" + String.valueOf(this.v) + "]";
    }
}

