/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Range;
import org.springframework.data.domain.Score;
import org.springframework.data.domain.ScoringFunction;
import org.springframework.data.domain.Vector;
import org.springframework.data.jpa.provider.PersistenceProvider;
import org.springframework.data.jpa.repository.query.EscapeCharacter;
import org.springframework.data.jpa.repository.query.JpaParameters;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.ParameterBinding;
import org.springframework.data.jpa.repository.query.SimilarityNormalizer;
import org.springframework.data.jpa.repository.support.JpqlQueryTemplates;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.expression.Expression;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class ParameterMetadataProvider {
    static final Object PLACEHOLDER = new Object();
    private final Iterator<? extends Parameter> parameters;
    @Nullable
    private final JpaParametersParameterAccessor accessor;
    private final List<ParameterBinding> bindings;
    private final Set<String> syntheticParameterNames = new LinkedHashSet<String>();
    @Nullable
    private ParameterBinding vector;
    @Nullable
    private final Iterator<Object> bindableParameterValues;
    private final EscapeCharacter escape;
    private final JpqlQueryTemplates templates;
    private final JpaParameters jpaParameters;
    private final PersistenceProvider persistenceProvider;
    private int position;
    private int bindMarker;

    public ParameterMetadataProvider(JpaParametersParameterAccessor accessor, EscapeCharacter escape, JpqlQueryTemplates templates) {
        this(accessor.iterator(), accessor, accessor.getParameters(), escape, templates, PersistenceProvider.GENERIC_JPA);
    }

    ParameterMetadataProvider(JpaParametersParameterAccessor accessor, EscapeCharacter escape, JpqlQueryTemplates templates, PersistenceProvider persistenceProvider) {
        this(accessor.iterator(), accessor, accessor.getParameters(), escape, templates, persistenceProvider);
    }

    public ParameterMetadataProvider(JpaParameters parameters, EscapeCharacter escape, JpqlQueryTemplates templates) {
        this(null, null, parameters, escape, templates, PersistenceProvider.HIBERNATE);
    }

    private ParameterMetadataProvider(@Nullable Iterator<Object> bindableParameterValues, @Nullable JpaParametersParameterAccessor accessor, JpaParameters parameters, EscapeCharacter escape, JpqlQueryTemplates templates, PersistenceProvider persistenceProvider) {
        Assert.notNull((Object)((Object)parameters), (String)"Parameters must not be null");
        Assert.notNull((Object)escape, (String)"EscapeCharacter must not be null");
        Assert.notNull((Object)templates, (String)"JpqlQueryTemplates must not be null");
        this.jpaParameters = parameters;
        this.accessor = accessor;
        this.parameters = ((JpaParameters)parameters.getBindableParameters()).iterator();
        this.bindings = new ArrayList<ParameterBinding>();
        this.bindableParameterValues = bindableParameterValues;
        this.escape = escape;
        this.templates = templates;
        this.persistenceProvider = persistenceProvider;
    }

    JpaParameters getParameters() {
        return this.jpaParameters;
    }

    public List<ParameterBinding> getBindings() {
        return this.bindings;
    }

    SimilarityNormalizer getSimilarityNormalizer() {
        if (this.accessor != null && this.accessor.normalizeSimilarity()) {
            return SimilarityNormalizer.get(this.accessor.getScoringFunction());
        }
        return SimilarityNormalizer.IDENTITY;
    }

    ParameterBinding.PartTreeParameterBinding next(Part part) {
        Assert.isTrue((boolean)this.parameters.hasNext(), () -> String.format("No parameter available for part %s", part));
        Parameter parameter = this.parameters.next();
        return this.next(part, parameter.getType(), parameter);
    }

    <T> ParameterBinding.PartTreeParameterBinding next(Part part, Class<T> type) {
        Parameter parameter = this.parameters.next();
        Class typeToUse = ClassUtils.isAssignable(type, (Class)parameter.getType()) ? parameter.getType() : type;
        return this.next(part, typeToUse, parameter);
    }

    private <T> ParameterBinding.PartTreeParameterBinding next(Part part, Class<T> type, Parameter parameter) {
        Assert.notNull(type, (String)"Type must not be null");
        Class reifiedType = Expression.class.equals(type) ? Object.class : type;
        Object value = this.bindableParameterValues == null ? PLACEHOLDER : this.bindableParameterValues.next();
        int currentPosition = ++this.position;
        int currentBindMarker = ++this.bindMarker;
        ParameterBinding.BindingIdentifier bindingIdentifier = parameter.getName().map(it -> ParameterBinding.BindingIdentifier.of(it, currentBindMarker)).orElseGet(() -> ParameterBinding.BindingIdentifier.of(currentBindMarker));
        ParameterBinding.BindingIdentifier origin = parameter.getName().map(it -> ParameterBinding.BindingIdentifier.of(it, currentPosition)).orElseGet(() -> ParameterBinding.BindingIdentifier.of(currentPosition));
        ParameterBinding.MethodInvocationArgument methodParameter = ParameterBinding.ParameterOrigin.ofParameter(origin);
        ParameterBinding.PartTreeParameterBinding binding = new ParameterBinding.PartTreeParameterBinding(bindingIdentifier, methodParameter, reifiedType, part, value, this.templates, this.escape, this.persistenceProvider);
        this.bindings.add(binding);
        if (Vector.class.isAssignableFrom(parameter.getType())) {
            this.vector = binding;
        }
        return binding;
    }

    ScoringFunction getScoringFunction() {
        if (this.accessor != null) {
            return this.accessor.getScoringFunction();
        }
        return ScoringFunction.unspecified();
    }

    ParameterBinding getVectorBinding() {
        if (!this.getParameters().hasVectorParameter()) {
            throw new IllegalStateException("Vector parameter not available");
        }
        if (this.vector != null) {
            return this.vector;
        }
        int vectorIndex = this.getParameters().getVectorIndex();
        ParameterBinding.BindingIdentifier bindingIdentifier = ParameterBinding.BindingIdentifier.of(vectorIndex + 1);
        ParameterBinding.MethodInvocationArgument methodParameter = ParameterBinding.ParameterOrigin.ofParameter(bindingIdentifier);
        ParameterBinding parameterBinding = new ParameterBinding(bindingIdentifier, methodParameter);
        this.bindings.add(parameterBinding);
        return parameterBinding;
    }

    EscapeCharacter getEscape() {
        return this.escape;
    }

    ParameterBinding nextSynthetic(String nameHint, Object value, Object source) {
        int currentPosition = ++this.bindMarker;
        Object bindingName = nameHint;
        if (!this.syntheticParameterNames.add((String)bindingName)) {
            bindingName = (String)bindingName + "_" + currentPosition;
            this.syntheticParameterNames.add((String)bindingName);
        }
        return new ParameterBinding(ParameterBinding.BindingIdentifier.of((String)bindingName, currentPosition), ParameterBinding.ParameterOrigin.synthetic(value, source));
    }

    RangeParameterBinding lower(ParameterBinding.PartTreeParameterBinding within, SimilarityNormalizer normalizer) {
        int bindMarker = within.getRequiredPosition();
        if (!this.bindings.remove(within)) {
            bindMarker = ++this.bindMarker;
        }
        ParameterBinding.BindingIdentifier identifier = within.getIdentifier();
        RangeParameterBinding rangeBinding = new RangeParameterBinding(identifier.mapName(name -> name + "_lower").withPosition(bindMarker), within.getOrigin(), true, normalizer);
        this.bindings.add(rangeBinding);
        return rangeBinding;
    }

    RangeParameterBinding upper(ParameterBinding.PartTreeParameterBinding within, SimilarityNormalizer normalizer) {
        int bindMarker = within.getRequiredPosition();
        if (!this.bindings.remove(within)) {
            bindMarker = ++this.bindMarker;
        }
        ParameterBinding.BindingIdentifier identifier = within.getIdentifier();
        RangeParameterBinding rangeBinding = new RangeParameterBinding(identifier.mapName(name -> name + "_upper").withPosition(bindMarker), within.getOrigin(), false, normalizer);
        this.bindings.add(rangeBinding);
        return rangeBinding;
    }

    ScoreParameterBinding normalize(ParameterBinding.PartTreeParameterBinding within, SimilarityNormalizer normalizer) {
        this.bindings.remove(within);
        ScoreParameterBinding rangeBinding = new ScoreParameterBinding(within.getIdentifier(), within.getOrigin(), normalizer);
        this.bindings.add(rangeBinding);
        return rangeBinding;
    }

    static class RangeParameterBinding
    extends ScoreParameterBinding {
        private final boolean lower;

        RangeParameterBinding(ParameterBinding.BindingIdentifier identifier, ParameterBinding.ParameterOrigin origin, boolean lower, SimilarityNormalizer normalizer) {
            super(identifier, origin, normalizer);
            this.lower = lower;
        }

        @Override
        @Nullable
        public Object prepare(@Nullable Object valueToBind) {
            if (valueToBind instanceof Range) {
                Range r = (Range)valueToBind;
                if (this.lower) {
                    return super.prepare(r.getLowerBound().getValue().orElse(null));
                }
                return super.prepare(r.getUpperBound().getValue().orElse(null));
            }
            return super.prepare(valueToBind);
        }

        @Override
        public boolean isCompatibleWith(ParameterBinding binding) {
            if (super.isCompatibleWith(binding) && binding instanceof RangeParameterBinding) {
                RangeParameterBinding other = (RangeParameterBinding)binding;
                return this.lower == other.lower;
            }
            return false;
        }
    }

    static class ScoreParameterBinding
    extends ParameterBinding {
        private final SimilarityNormalizer normalizer;

        ScoreParameterBinding(ParameterBinding.BindingIdentifier identifier, ParameterBinding.ParameterOrigin origin, SimilarityNormalizer normalizer) {
            super(identifier, origin);
            this.normalizer = normalizer;
        }

        @Override
        @Nullable
        public Object prepare(@Nullable Object valueToBind) {
            if (valueToBind instanceof Score) {
                Score score = (Score)valueToBind;
                return this.normalizer.getScore(score.getValue());
            }
            return super.prepare(valueToBind);
        }

        @Override
        public boolean isCompatibleWith(ParameterBinding binding) {
            if (super.isCompatibleWith(binding) && binding instanceof ScoreParameterBinding) {
                ScoreParameterBinding other = (ScoreParameterBinding)binding;
                return this.normalizer == other.normalizer;
            }
            return false;
        }
    }
}

