/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.util.ObjectUtils;

class DeclaredQueries {
    DeclaredQueries() {
    }

    static final class JpqlQuery
    implements DeclaredQuery {
        private final String jpql;

        JpqlQuery(String jpql) {
            this.jpql = jpql;
        }

        @Override
        public boolean isNative() {
            return false;
        }

        @Override
        public String getQueryString() {
            return this.jpql;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void jpqlQuery;
            if (!(o instanceof JpqlQuery)) {
                return false;
            }
            JpqlQuery jpqlQuery2 = (JpqlQuery)o;
            return ObjectUtils.nullSafeEquals((Object)this.jpql, (Object)jpqlQuery.jpql);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode((Object)this.jpql);
        }

        public String toString() {
            return "JPQL[" + this.jpql + "]";
        }
    }

    static final class NativeQuery
    implements DeclaredQuery {
        private final String sql;

        NativeQuery(String sql) {
            this.sql = sql;
        }

        @Override
        public boolean isNative() {
            return true;
        }

        @Override
        public String getQueryString() {
            return this.sql;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void that;
            if (!(o instanceof NativeQuery)) {
                return false;
            }
            NativeQuery nativeQuery = (NativeQuery)o;
            return ObjectUtils.nullSafeEquals((Object)this.sql, (Object)that.sql);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode((Object)this.sql);
        }

        public String toString() {
            return "Native[" + this.sql + "]";
        }
    }

    static class RewrittenQuery
    implements DeclaredQuery {
        private final DeclaredQuery source;
        private final String queryString;

        public RewrittenQuery(DeclaredQuery source, String queryString) {
            this.source = source;
            this.queryString = queryString;
        }

        @Override
        public boolean isNative() {
            return this.source.isNative();
        }

        @Override
        public String getQueryString() {
            return this.queryString;
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void that;
            if (!(o instanceof RewrittenQuery)) {
                return false;
            }
            RewrittenQuery rewrittenQuery = (RewrittenQuery)o;
            return ObjectUtils.nullSafeEquals((Object)this.queryString, (Object)that.queryString);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode((Object)this.queryString);
        }

        public String toString() {
            return this.isNative() ? "Rewritten Native[" + this.queryString + "]" : "Rewritten JPQL[" + this.queryString + "]";
        }
    }
}

