/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import org.jspecify.annotations.Nullable;
import org.springframework.data.jpa.repository.query.DeclaredQuery;
import org.springframework.data.jpa.repository.query.QueryEnhancer;
import org.springframework.data.jpa.repository.query.QueryProvider;
import org.springframework.data.jpa.repository.query.QueryUtils;

class DefaultQueryEnhancer
implements QueryEnhancer {
    private final QueryProvider query;
    private final boolean hasConstructorExpression;
    @Nullable
    private final String alias;
    private final String projection;

    public DefaultQueryEnhancer(QueryProvider query) {
        this.query = query;
        this.hasConstructorExpression = QueryUtils.hasConstructorExpression(query.getQueryString());
        this.alias = QueryUtils.detectAlias(query.getQueryString());
        this.projection = QueryUtils.getProjection(this.query.getQueryString());
    }

    @Override
    public String rewrite(QueryEnhancer.QueryRewriteInformation rewriteInformation) {
        return QueryUtils.applySorting(this.query.getQueryString(), rewriteInformation.getSort(), this.alias);
    }

    @Override
    public String createCountQueryFor(@Nullable String countProjection) {
        boolean bl;
        QueryProvider queryProvider = this.query;
        if (queryProvider instanceof DeclaredQuery) {
            DeclaredQuery dc = (DeclaredQuery)queryProvider;
            bl = dc.isNative();
        } else {
            bl = true;
        }
        boolean nativeQuery = bl;
        return QueryUtils.createCountQueryFor(this.query.getQueryString(), countProjection, nativeQuery);
    }

    @Override
    public boolean hasConstructorExpression() {
        return this.hasConstructorExpression;
    }

    @Override
    @Nullable
    public String detectAlias() {
        return this.alias;
    }

    @Override
    public String getProjection() {
        return this.projection;
    }

    @Override
    public QueryProvider getQuery() {
        return this.query;
    }
}

