/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;

class SqlContext {
    SqlContext() {
    }

    Table getTable(AggregatePath path) {
        Table table = this.getUnaliasedTable(path);
        AggregatePath.TableInfo tableInfo = path.getTableInfo();
        SqlIdentifier tableAlias = tableInfo.tableAlias();
        return tableAlias == null ? table : table.as(tableAlias);
    }

    Column getColumn(AggregatePath path) {
        AggregatePath.ColumnInfo columnInfo = path.getColumnInfo();
        return this.getTable(path).column(columnInfo.name()).as(columnInfo.alias());
    }

    Column getAnyReverseColumn(AggregatePath path) {
        AggregatePath.ColumnInfo anyReverseColumnInfo = path.getTableInfo().backReferenceColumnInfos().any();
        return this.getTable(path).column(anyReverseColumnInfo.name()).as(anyReverseColumnInfo.alias());
    }

    public Table getUnaliasedTable(AggregatePath path) {
        AggregatePath.TableInfo tableInfo = path.getTableInfo();
        return Table.create((SqlIdentifier)tableInfo.qualifiedTableName());
    }
}

