/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.dialect;

import java.sql.JDBCType;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.jdbc.core.dialect.JdbcDialect;
import org.springframework.data.jdbc.core.mapping.JdbcValue;
import org.springframework.data.relational.core.dialect.MySqlDialect;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.lang.NonNull;

public class JdbcMySqlDialect
extends MySqlDialect
implements JdbcDialect {
    @Deprecated(forRemoval=true, since="4.0")
    public static final JdbcMySqlDialect INSTANCE = new JdbcMySqlDialect();

    public JdbcMySqlDialect(IdentifierProcessing identifierProcessing) {
        super(identifierProcessing);
    }

    protected JdbcMySqlDialect() {
    }

    public Collection<Object> getConverters() {
        ArrayList<Object> converters = new ArrayList<Object>(super.getConverters());
        converters.add((Object)OffsetDateTimeToTimestampJdbcValueConverter.INSTANCE);
        converters.add((Object)LocalDateTimeToDateConverter.INSTANCE);
        return converters;
    }

    @WritingConverter
    static enum OffsetDateTimeToTimestampJdbcValueConverter implements Converter<OffsetDateTime, JdbcValue>
    {
        INSTANCE;


        public JdbcValue convert(OffsetDateTime source) {
            return JdbcValue.of(source, JDBCType.TIMESTAMP);
        }
    }

    @ReadingConverter
    static enum LocalDateTimeToDateConverter implements Converter<LocalDateTime, Date>
    {
        INSTANCE;


        @NonNull
        public Date convert(LocalDateTime source) {
            return Date.from(source.atZone(ZoneId.systemDefault()).toInstant());
        }
    }
}

