/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.ClassUtils;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum JdbcColumnTypes {
    INSTANCE{

        @Override
        public Class<?> resolvePrimitiveType(Class<?> type) {
            return javaToDbType.entrySet().stream().filter(e -> ((Class)e.getKey()).isAssignableFrom(type)).map(e -> (Class)e.getValue()).findFirst().orElseGet(() -> ClassUtils.resolvePrimitiveIfNecessary((Class)type));
        }
    };

    private static final Map<Class<?>, Class<?>> javaToDbType;

    public abstract Class<?> resolvePrimitiveType(Class<?> var1);

    static {
        javaToDbType = new LinkedHashMap();
        javaToDbType.put(Enum.class, String.class);
        javaToDbType.put(ZonedDateTime.class, String.class);
        javaToDbType.put(OffsetDateTime.class, OffsetDateTime.class);
        javaToDbType.put(LocalDateTime.class, LocalDateTime.class);
        javaToDbType.put(Temporal.class, Timestamp.class);
    }
}

