/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.sql.ResultSet;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.query.AbstractJdbcQuery;
import org.springframework.data.jdbc.repository.query.JdbcQueryCreator;
import org.springframework.data.jdbc.repository.query.JdbcQueryExecution;
import org.springframework.data.jdbc.repository.query.JdbcQueryMethod;
import org.springframework.data.jdbc.repository.query.ParametrizedQuery;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.repository.query.RelationalEntityMetadata;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalParametersParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

public class PartTreeJdbcQuery
extends AbstractJdbcQuery {
    private final RelationalMappingContext context;
    private final Parameters<?, ?> parameters;
    private final Dialect dialect;
    private final JdbcConverter converter;
    private final PartTree tree;
    private final JdbcQueryExecution<?> execution;

    public PartTreeJdbcQuery(RelationalMappingContext context, JdbcQueryMethod queryMethod, Dialect dialect, JdbcConverter converter, NamedParameterJdbcOperations operations, RowMapper<Object> rowMapper) {
        super(queryMethod, operations, rowMapper);
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null");
        Assert.notNull((Object)((Object)queryMethod), (String)"JdbcQueryMethod must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        this.context = context;
        this.parameters = queryMethod.getParameters();
        this.dialect = dialect;
        this.converter = converter;
        this.tree = new PartTree(queryMethod.getName(), queryMethod.getEntityInformation().getJavaType());
        JdbcQueryCreator.validate(this.tree, this.parameters, this.converter.getMappingContext());
        ResultSetExtractor extractor = this.tree.isExistsProjection() ? ResultSet::next : null;
        this.execution = this.getQueryExecution(queryMethod, extractor, rowMapper);
    }

    private Sort getDynamicSort(RelationalParameterAccessor accessor) {
        return this.parameters.potentiallySortsDynamically() ? accessor.getSort() : Sort.unsorted();
    }

    public Object execute(Object[] values) {
        RelationalParametersParameterAccessor accessor = new RelationalParametersParameterAccessor((QueryMethod)this.getQueryMethod(), values);
        ParametrizedQuery query = this.createQuery(accessor);
        return this.execution.execute(query.getQuery(), query.getParameterSource());
    }

    protected ParametrizedQuery createQuery(RelationalParametersParameterAccessor accessor) {
        RelationalEntityMetadata<?> entityMetadata = this.getQueryMethod().getEntityInformation();
        JdbcQueryCreator queryCreator = new JdbcQueryCreator(this.context, this.tree, this.converter, this.dialect, entityMetadata, (RelationalParameterAccessor)accessor);
        return (ParametrizedQuery)queryCreator.createQuery(this.getDynamicSort((RelationalParameterAccessor)accessor));
    }
}

