/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.geode.cache.CacheEvent;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionAttributes;
import org.apache.geode.cache.RegionEvent;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.springframework.data.gemfire.RegionResolver;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public abstract class AbstractCachingRegionResolver
extends CacheListenerAdapter
implements RegionResolver {
    private final Map<String, Region> nameToRegionCache = new ConcurrentHashMap<String, Region>();

    synchronized void cache(@Nullable Region region) {
        Optional.ofNullable(region).filter(it -> StringUtils.hasText((String)region.getName())).ifPresent(it -> this.nameToRegionCache.put(region.getName(), region));
    }

    @Override
    @Nullable
    public synchronized <K, V> Region<K, V> resolve(@Nullable String regionName) {
        return StringUtils.hasText((String)regionName) ? this.nameToRegionCache.computeIfAbsent(regionName, this::doResolveAndRegisterResolverAsCacheListener) : null;
    }

    <K, V> Region<K, V> doResolveAndRegisterResolverAsCacheListener(String regionName) {
        return Optional.ofNullable(this.doResolve(regionName)).map(Region::getAttributesMutator).map(attributesMutator -> {
            attributesMutator.addCacheListener((CacheListener)this);
            return attributesMutator.getRegion();
        }).orElse(null);
    }

    private boolean isResolverNotRegisteredAsCacheListener(Region region) {
        return region != null && !this.isResolverRegisteredAsCacheListener(region);
    }

    private boolean isResolverRegisteredAsCacheListener(Region region) {
        return Optional.ofNullable(region).map(Region::getAttributes).map(RegionAttributes::getCacheListeners).map(Arrays::asList).filter(cacheListeners -> cacheListeners.contains(this)).isPresent();
    }

    @Nullable
    protected abstract <K, V> Region<K, V> doResolve(@Nullable String var1);

    public void afterRegionDestroy(@Nullable RegionEvent event) {
        Optional.ofNullable(event).map(CacheEvent::getRegion).map(Region::getName).filter(StringUtils::hasText).ifPresent(this::remove);
    }

    synchronized void remove(@NonNull String regionName) {
        this.nameToRegionCache.remove(regionName);
    }
}

