/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query.support;

import org.springframework.util.StringUtils;

public enum OqlKeyword {
    AND,
    AS,
    COUNT,
    DISTINCT,
    ELEMENT,
    FROM,
    HINT,
    IMPORT,
    IN,
    IS_DEFINED,
    IS_UNDEFINED,
    LIMIT,
    LIKE,
    NOT,
    NVL,
    OR,
    ORDER_BY("ORDER BY"),
    SELECT,
    SET,
    TRACE,
    TO_DATE,
    TYPE,
    WHERE;

    private final String keyword;

    private OqlKeyword() {
        this(null);
    }

    private OqlKeyword(String keyword) {
        this.keyword = keyword;
    }

    public static OqlKeyword valueOfIgnoreCase(String keyword) {
        for (OqlKeyword oqlKeyword : OqlKeyword.values()) {
            if (!oqlKeyword.getKeyword().equalsIgnoreCase(StringUtils.trimWhitespace((String)keyword))) continue;
            return oqlKeyword;
        }
        throw new IllegalArgumentException(String.format("[%s] is not a valid GemFire OQL Keyword", keyword));
    }

    public String getKeyword() {
        return StringUtils.hasText((String)this.keyword) ? this.keyword : this.name();
    }

    public String toString() {
        return this.getKeyword();
    }
}

