/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.gemfire.repository.query.GemfireQueryMethod;
import org.springframework.data.gemfire.repository.query.QueryPostProcessor;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class GemfireRepositoryQuery
implements RepositoryQuery {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final GemfireQueryMethod queryMethod;
    private QueryPostProcessor<Repository, String> queryPostProcessor = ProvidedQueryPostProcessor.IDENTITY;

    GemfireRepositoryQuery() {
        this.queryMethod = null;
    }

    public GemfireRepositoryQuery(GemfireQueryMethod queryMethod) {
        Assert.notNull((Object)((Object)queryMethod), (String)"QueryMethod must not be null");
        this.queryMethod = queryMethod;
    }

    @NonNull
    protected GemfireQueryMethod getGemfireQueryMethod() {
        return (GemfireQueryMethod)this.getQueryMethod();
    }

    @NonNull
    protected Logger getLogger() {
        return this.logger;
    }

    @NonNull
    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    @NonNull
    protected QueryPostProcessor<Repository, String> getQueryPostProcessor() {
        return this.queryPostProcessor;
    }

    public GemfireRepositoryQuery register(@Nullable QueryPostProcessor<Repository, String> queryPostProcessor) {
        this.queryPostProcessor = this.queryPostProcessor.processBefore(queryPostProcessor);
        return this;
    }

    static enum ProvidedQueryPostProcessor implements QueryPostProcessor<Repository, String>
    {
        IDENTITY{

            @Override
            public String postProcess(QueryMethod queryMethod, String query, Object ... arguments) {
                return query;
            }
        };

    }
}

