/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.execution;

import java.util.Optional;
import org.apache.geode.cache.RegionService;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.Pool;
import org.springframework.data.gemfire.client.PoolResolver;
import org.springframework.data.gemfire.client.support.PoolManagerPoolResolver;
import org.springframework.data.gemfire.function.execution.AbstractFunctionExecution;
import org.springframework.data.gemfire.function.execution.AbstractFunctionTemplate;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractClientFunctionTemplate
extends AbstractFunctionTemplate {
    protected static final PoolResolver DEFAULT_POOL_RESOLVER = new PoolManagerPoolResolver();
    private Pool pool;
    private PoolResolver poolResolver = DEFAULT_POOL_RESOLVER;
    private RegionService regionService;
    private String poolName;

    public AbstractClientFunctionTemplate(RegionService regionService) {
        this.regionService = regionService;
    }

    public AbstractClientFunctionTemplate(Pool pool) {
        this.pool = pool;
    }

    public AbstractClientFunctionTemplate(String poolName) {
        this.poolName = poolName;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setPoolResolver(PoolResolver poolResolver) {
        this.poolResolver = poolResolver;
    }

    protected PoolResolver getPoolResolver() {
        PoolResolver poolResolver = this.poolResolver;
        return poolResolver != null ? poolResolver : DEFAULT_POOL_RESOLVER;
    }

    protected Object resolveRequiredGemFireObject() {
        return Optional.ofNullable(this.resolvePool()).orElseGet(this::resolveClientCache);
    }

    @Deprecated
    protected ClientCache resolveClientCache() {
        return (ClientCache)this.resolveRegionService();
    }

    protected Pool resolvePool() {
        if (this.pool == null) {
            this.pool = this.resolveNamedPool();
        }
        return this.pool;
    }

    protected Pool resolveDefaultPool() {
        return Optional.ofNullable(this.getPoolResolver().resolve("DEFAULT")).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("DEFAULT Pool is not present", new Object[0]));
    }

    protected Pool resolveNamedPool() {
        if (StringUtils.hasText((String)this.poolName)) {
            this.pool = Optional.ofNullable(this.getPoolResolver().resolve(this.poolName)).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("Pool with name [%s] is not present", this.poolName));
        }
        return this.pool;
    }

    protected RegionService resolveRegionService() {
        ClientCache resolvedRegionService = this.regionService != null ? this.regionService : CacheUtils.getClientCache();
        return (RegionService)Optional.ofNullable(resolvedRegionService).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("ClientCache is not present", new Object[0]));
    }

    @Override
    protected AbstractFunctionExecution getFunctionExecution() {
        Object gemfireObject = this.resolveRequiredGemFireObject();
        return gemfireObject instanceof Pool ? this.newFunctionExecutionUsingPool((Pool)gemfireObject) : this.newFunctionExecutionUsingRegionService((RegionService)gemfireObject);
    }

    protected abstract AbstractFunctionExecution newFunctionExecutionUsingPool(Pool var1);

    protected abstract AbstractFunctionExecution newFunctionExecutionUsingRegionService(RegionService var1);
}

