/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.context.annotation.ScannedGenericBeanDefinition;
import org.springframework.core.io.ResourceLoader;
import org.springframework.data.gemfire.function.annotation.OnMember;
import org.springframework.data.gemfire.function.annotation.OnMembers;
import org.springframework.data.gemfire.function.annotation.OnRegion;
import org.springframework.data.gemfire.function.annotation.OnServer;
import org.springframework.data.gemfire.function.annotation.OnServers;
import org.springframework.data.gemfire.function.config.FunctionExecutionComponentProvider;
import org.springframework.data.gemfire.function.config.FunctionExecutionConfigurationSource;
import org.springframework.data.gemfire.util.CollectionUtils;

public abstract class AbstractFunctionExecutionConfigurationSource
implements FunctionExecutionConfigurationSource {
    private static Set<Class<? extends Annotation>> functionExecutionAnnotationTypes;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public static Set<Class<? extends Annotation>> getFunctionExecutionAnnotationTypes() {
        return functionExecutionAnnotationTypes;
    }

    public static Set<String> getFunctionExecutionAnnotationTypeNames() {
        return AbstractFunctionExecutionConfigurationSource.getFunctionExecutionAnnotationTypes().stream().map(Class::getName).collect(Collectors.toSet());
    }

    public Collection<ScannedGenericBeanDefinition> getCandidates(ResourceLoader loader) {
        FunctionExecutionComponentProvider scanner = new FunctionExecutionComponentProvider(this.getIncludeFilters(), AbstractFunctionExecutionConfigurationSource.getFunctionExecutionAnnotationTypes());
        scanner.setResourceLoader(loader);
        StreamSupport.stream(CollectionUtils.nullSafeIterable(this.getExcludeFilters()).spliterator(), false).forEach(arg_0 -> ((ClassPathScanningCandidateComponentProvider)scanner).addExcludeFilter(arg_0));
        HashSet<ScannedGenericBeanDefinition> result = new HashSet<ScannedGenericBeanDefinition>();
        for (String basePackage : this.getBasePackages()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Scanning Package [{}]", (Object)basePackage);
            }
            scanner.findCandidateComponents(basePackage).stream().map(ScannedGenericBeanDefinition.class::cast).forEach(result::add);
        }
        return result;
    }

    static {
        HashSet<Class<OnServers>> annotationTypes = new HashSet<Class<OnServers>>(5);
        annotationTypes.add(OnMember.class);
        annotationTypes.add(OnMembers.class);
        annotationTypes.add(OnRegion.class);
        annotationTypes.add(OnServer.class);
        annotationTypes.add(OnServers.class);
        functionExecutionAnnotationTypes = Collections.unmodifiableSet(annotationTypes);
    }
}

