/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.client.KeyInterest;
import org.springframework.data.gemfire.client.RegexInterest;
import org.springframework.data.gemfire.config.xml.AbstractRegionParser;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class ClientRegionParser
extends AbstractRegionParser {
    ClientRegionParser() {
    }

    @Override
    protected Class<?> getRegionFactoryClass() {
        return ClientRegionFactoryBean.class;
    }

    @Override
    protected void doParseRegion(Element element, ParserContext parserContext, BeanDefinitionBuilder regionBuilder, boolean subRegion) {
        this.validateDataPolicyShortcutAttributesMutualExclusion(element, parserContext);
        String resolvedCacheRef = ParsingUtils.resolveCacheReference(element.getAttribute("cache-ref"));
        if (!subRegion) {
            regionBuilder.addPropertyReference("cache", resolvedCacheRef);
            ParsingUtils.setPropertyValue(element, regionBuilder, "close");
            ParsingUtils.setPropertyValue(element, regionBuilder, "destroy");
        }
        ParsingUtils.setPropertyValue(element, regionBuilder, "name");
        ParsingUtils.setPropertyValue(element, regionBuilder, "data-policy");
        ParsingUtils.setPropertyValue(element, regionBuilder, "ignore-if-exists", "lookupEnabled");
        ParsingUtils.setPropertyValue(element, regionBuilder, "persistent");
        ParsingUtils.setPropertyValue(element, regionBuilder, "pool-name");
        ParsingUtils.setPropertyValue(element, regionBuilder, "shortcut");
        this.parseDiskStoreAttribute(element, regionBuilder);
        BeanDefinitionBuilder regionAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegionAttributesFactoryBean.class);
        this.mergeRegionTemplateAttributes(element, parserContext, regionBuilder, regionAttributesBuilder);
        ParsingUtils.parseOptionalRegionAttributes(element, parserContext, regionAttributesBuilder);
        ParsingUtils.parseStatistics(element, regionAttributesBuilder);
        ParsingUtils.parseExpiration(element, parserContext, regionAttributesBuilder);
        ParsingUtils.parseEviction(element, parserContext, regionAttributesBuilder);
        ParsingUtils.parseCompressor(element, parserContext, regionAttributesBuilder);
        regionBuilder.addPropertyValue("attributes", (Object)regionAttributesBuilder.getBeanDefinition());
        List subElements = DomUtils.getChildElements((Element)element);
        ManagedList interests = new ManagedList();
        for (Element subElement : subElements) {
            String subElementLocalName = subElement.getLocalName();
            if ("cache-listener".equals(subElementLocalName)) {
                regionBuilder.addPropertyValue("cacheListeners", ParsingUtils.parseRefOrNestedBeanDeclaration(subElement, parserContext, regionBuilder));
                continue;
            }
            if ("cache-loader".equals(subElementLocalName)) {
                regionBuilder.addPropertyValue("cacheLoader", ParsingUtils.parseRefOrNestedBeanDeclaration(subElement, parserContext, regionBuilder));
                continue;
            }
            if ("cache-writer".equals(subElementLocalName)) {
                regionBuilder.addPropertyValue("cacheWriter", ParsingUtils.parseRefOrNestedBeanDeclaration(subElement, parserContext, regionBuilder));
                continue;
            }
            if ("key-interest".equals(subElementLocalName)) {
                interests.add(this.parseKeyInterest(subElement, parserContext));
                continue;
            }
            if (!"regex-interest".equals(subElementLocalName)) continue;
            interests.add(this.parseRegexInterest(subElement));
        }
        if (!interests.isEmpty()) {
            regionBuilder.addPropertyValue("interests", (Object)interests);
        }
        if (!subRegion) {
            this.parseSubRegions(element, parserContext, resolvedCacheRef);
        }
    }

    private void parseDiskStoreAttribute(Element element, BeanDefinitionBuilder builder) {
        String diskStoreRefAttribute = element.getAttribute("disk-store-ref");
        if (StringUtils.hasText((String)diskStoreRefAttribute)) {
            builder.addPropertyValue("diskStoreName", (Object)diskStoreRefAttribute);
            builder.addDependsOn(diskStoreRefAttribute);
        }
    }

    private void parseCommonInterestAttributes(Element element, BeanDefinitionBuilder builder) {
        ParsingUtils.setPropertyValue(element, builder, "durable", "durable");
        ParsingUtils.setPropertyValue(element, builder, "receive-values", "receiveValues");
        ParsingUtils.setPropertyValue(element, builder, "result-policy", "policy");
    }

    private Object parseKeyInterest(Element keyInterestElement, ParserContext parserContext) {
        BeanDefinitionBuilder keyInterestBuilder = BeanDefinitionBuilder.genericBeanDefinition(KeyInterest.class);
        keyInterestBuilder.addConstructorArgValue(ParsingUtils.parseRefOrNestedBeanDeclaration(keyInterestElement, parserContext, keyInterestBuilder, "key-ref"));
        this.parseCommonInterestAttributes(keyInterestElement, keyInterestBuilder);
        return keyInterestBuilder.getBeanDefinition();
    }

    private Object parseRegexInterest(Element regexInterestElement) {
        BeanDefinitionBuilder regexInterestBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegexInterest.class);
        regexInterestBuilder.addConstructorArgValue((Object)regexInterestElement.getAttribute("pattern"));
        this.parseCommonInterestAttributes(regexInterestElement, regexInterestBuilder);
        return regexInterestBuilder.getBeanDefinition();
    }
}

