/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.support;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class AutoRegionLookupBeanPostProcessor
implements BeanPostProcessor,
BeanFactoryAware {
    private ConfigurableListableBeanFactory beanFactory;

    public final void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)String.format("BeanFactory [%1$s] must be an instance of %2$s", ObjectUtils.nullSafeClassName((Object)beanFactory), ConfigurableListableBeanFactory.class.getSimpleName()));
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        return Optional.ofNullable(this.beanFactory).orElseThrow(() -> RuntimeExceptionFactory.newIllegalStateException("BeanFactory was not properly configured", new Object[0]));
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof GemFireCache) {
            this.registerCacheRegionsAsBeans((GemFireCache)bean);
        }
        return bean;
    }

    void registerCacheRegionsAsBeans(GemFireCache cache) {
        cache.rootRegions().forEach(this::registerCacheRegionAsBean);
    }

    void registerCacheRegionAsBean(Region<?, ?> region) {
        if (region != null) {
            String regionBeanName = this.getBeanName(region);
            if (!this.getBeanFactory().containsBean(regionBeanName)) {
                this.getBeanFactory().registerSingleton(regionBeanName, region);
            }
            for (Region<?, ?> subregion : this.nullSafeSubregions(region)) {
                this.registerCacheRegionAsBean(subregion);
            }
        }
    }

    String getBeanName(Region region) {
        return Optional.ofNullable(region.getFullPath()).filter(StringUtils::hasText).filter(regionFullPath -> regionFullPath.lastIndexOf("/") > 0).orElseGet(() -> ((Region)region).getName());
    }

    Set<Region<?, ?>> nullSafeSubregions(Region<?, ?> parentRegion) {
        return Optional.ofNullable(parentRegion.subregions(false)).orElse(Collections.emptySet());
    }
}

