/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.support;

import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.core.type.MethodMetadata;
import org.springframework.data.gemfire.GenericRegionFactoryBean;
import org.springframework.data.gemfire.LocalRegionFactoryBean;
import org.springframework.data.gemfire.PartitionedRegionFactoryBean;
import org.springframework.data.gemfire.ReplicatedRegionFactoryBean;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.client.PoolFactoryBean;
import org.springframework.data.gemfire.util.SpringExtensions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractDependencyStructuringBeanFactoryPostProcessor
implements BeanFactoryPostProcessor {
    protected BeanDefinition addDependsOn(BeanDefinition beanDefinition, String ... beanNames) {
        return SpringExtensions.addDependsOn(beanDefinition, beanNames);
    }

    protected Optional<Object> getPropertyValue(BeanDefinition beanDefinition, String propertyName) {
        return SpringExtensions.getPropertyValue(beanDefinition, propertyName);
    }

    protected boolean isBeanDefinitionOfType(BeanDefinition beanDefinition, Class<?> type) {
        Assert.notNull(type, (String)"Class type must not be null");
        return this.isBeanDefinitionOfType(beanDefinition, (String typeName) -> type.getName().equals(typeName));
    }

    protected boolean isBeanDefinitionOfType(BeanDefinition beanDefinition, String typeName) {
        return this.isBeanDefinitionOfType(beanDefinition, (String typeNameArgument) -> String.valueOf(typeName).equals(typeNameArgument));
    }

    protected boolean isBeanDefinitionOfType(BeanDefinition beanDefinition, Predicate<String> typeFilter) {
        return Optional.of(beanDefinition).map(it -> beanDefinition.getBeanClassName()).filter(StringUtils::hasText).map(typeFilter::test).orElseGet(() -> Optional.ofNullable(beanDefinition.getFactoryMethodName()).filter(StringUtils::hasText).filter(it -> beanDefinition instanceof AnnotatedBeanDefinition).map(it -> ((AnnotatedBeanDefinition)beanDefinition).getFactoryMethodMetadata()).map(MethodMetadata::getReturnTypeName).map(typeFilter::test).orElse(false));
    }

    protected boolean isClientCacheBean(BeanDefinition beanDefinition) {
        return this.isBeanDefinitionOfType(beanDefinition, ClientCacheFactoryBean.class);
    }

    protected boolean isClientRegionBean(BeanDefinition beanDefinition) {
        return this.isBeanDefinitionOfType(beanDefinition, ClientRegionFactoryBean.class);
    }

    protected boolean isPoolBean(BeanDefinition beanDefinition) {
        return this.isBeanDefinitionOfType(beanDefinition, PoolFactoryBean.class);
    }

    protected Predicate<String> isRegionBeanType() {
        Predicate<String> genericRegionBeanType = typeName -> GenericRegionFactoryBean.class.getName().equals(typeName);
        return genericRegionBeanType.or(typeName -> ClientRegionFactoryBean.class.getName().equals(typeName)).or(typeName -> LocalRegionFactoryBean.class.getName().equals(typeName)).or(typeName -> PartitionedRegionFactoryBean.class.getName().equals(typeName)).or(typeName -> ReplicatedRegionFactoryBean.class.getName().equals(typeName));
    }
}

