/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.schema;

import java.io.Serializable;
import java.util.Optional;
import org.springframework.core.Ordered;
import org.springframework.data.gemfire.config.admin.GemfireAdminOperations;
import org.springframework.data.gemfire.config.schema.SchemaObjectType;
import org.springframework.data.gemfire.util.RuntimeExceptionFactory;
import org.springframework.util.StringUtils;

public abstract class SchemaObjectDefinition
implements Serializable,
Ordered {
    private final String name;

    public SchemaObjectDefinition(String name) {
        this.name = Optional.ofNullable(name).filter(StringUtils::hasText).orElseThrow(() -> RuntimeExceptionFactory.newIllegalArgumentException("Name [%s] is required", name));
    }

    public String getName() {
        return this.name;
    }

    public abstract SchemaObjectType getType();

    public void create(GemfireAdminOperations gemfireAdminOperations) {
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SchemaObjectDefinition)) {
            return false;
        }
        SchemaObjectDefinition that = (SchemaObjectDefinition)obj;
        return this.getName().equals(that.getName()) && this.getType().equals((Object)that.getType());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + this.getName().hashCode();
        hashValue = 37 * hashValue + this.getType().hashCode();
        return hashValue;
    }

    public String toString() {
        return String.format("%1$s[%2$s]", new Object[]{this.getType(), this.getName()});
    }
}

