/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.geode.cache.GemFireCache;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.LocatorFactoryBean;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.data.gemfire.config.annotation.LazyResolvingComposableLocatorConfigurer;
import org.springframework.data.gemfire.config.annotation.LocatorApplication;
import org.springframework.data.gemfire.config.annotation.LocatorConfigurer;
import org.springframework.data.gemfire.config.annotation.support.AbstractAnnotationConfigSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;

@Configuration
public class LocatorApplicationConfiguration
extends AbstractAnnotationConfigSupport
implements ImportAware {
    public static final boolean DEFAULT_USE_BEAN_FACTORY_LOCATOR = false;
    public static final boolean DEFAULT_USE_CLUSTER_CONFIGURATTION_SERVICE = false;
    public static final int DEFAULT_PORT = 10334;
    public static final String DEFAULT_LOG_LEVEL = "warn";
    public static final String DEFAULT_NAME = "SpringBasedLocatorApplication";
    protected static final String LOCATOR_APPLICATION_MUTEX_ERROR_MESSAGE = "A Spring application cannot be both a Cache and a Locator application; You may annotate your Spring application main class with 1 of [@ClientCacheApplication, @CacheServerApplication, @PeerCacheApplication] or @LocatorApplication; If you want to create a Spring, Apache Geode server application (i.e. [@PeerCacheApplication,  @CacheServerApplication]) and also run an embedded Locator service, then use the @EnableLocator annotation with 1 of the server-side, cache application annotations instead; Locators are not applicable to clients.";
    private static final List<String> CACHE_FACTORY_BEAN_CLASS_NAMES = Arrays.asList(CacheFactoryBean.class.getName(), ClientCacheFactoryBean.class.getName());
    private boolean useBeanFactoryLocator = false;
    private boolean useClusterConfigurationService = false;
    private int port = 10334;
    @Autowired(required=false)
    private List<LocatorConfigurer> locatorConfigurers = Collections.emptyList();
    private String bindAddress;
    private String hostnameForClients;
    private String locators;
    private String logLevel;
    private String name;

    @Override
    @NonNull
    protected Class<? extends Annotation> getAnnotationType() {
        return LocatorApplication.class;
    }

    @Bean
    @NonNull
    BeanFactoryPostProcessor locatorApplicationMutexBeanFactoryPostProcessor() {
        return configurableListableBeanFactory -> {
            String[] beanDefinitionNames = configurableListableBeanFactory.getBeanDefinitionNames();
            boolean match = Arrays.stream(ArrayUtils.nullSafeArray(beanDefinitionNames, String.class)).map(arg_0 -> ((ConfigurableListableBeanFactory)configurableListableBeanFactory).getBeanDefinition(arg_0)).anyMatch(beanDefinition -> this.resolveBeanClassName((BeanDefinition)beanDefinition).map(beanClassName -> {
                try {
                    Class possibleCacheType = ClassUtils.resolveClassName((String)beanClassName, (ClassLoader)this.getBeanClassLoader());
                    return this.isCacheType(possibleCacheType);
                }
                catch (Throwable ignore) {
                    return CACHE_FACTORY_BEAN_CLASS_NAMES.contains(beanClassName);
                }
            }).orElse(false));
            if (match) {
                throw new BeanDefinitionStoreException(LOCATOR_APPLICATION_MUTEX_ERROR_MESSAGE);
            }
        };
    }

    private boolean isCacheType(Class<?> type) {
        return type != null && (CacheFactoryBean.class.isAssignableFrom(type) || GemFireCache.class.isAssignableFrom(type));
    }

    public void setImportMetadata(@NonNull AnnotationMetadata importMetadata) {
        if (this.isAnnotationPresent(importMetadata)) {
            AnnotationAttributes locatorApplicationAnnotationAttributes = this.getAnnotationAttributes(importMetadata);
            this.setBindAddress(this.resolveProperty(this.locatorProperty("bind-address"), locatorApplicationAnnotationAttributes.getString("bindAddress")));
            this.setHostnameForClients(this.resolveProperty(this.locatorProperty("hostname-for-clients"), locatorApplicationAnnotationAttributes.getString("hostnameForClients")));
            this.setLocators(this.resolveProperty(this.propertyName("locators"), locatorApplicationAnnotationAttributes.getString("locators")));
            this.setLogLevel(this.resolveProperty(this.locatorProperty("log-level"), locatorApplicationAnnotationAttributes.getString("logLevel")));
            this.setName(this.resolveProperty(this.locatorProperty("name"), locatorApplicationAnnotationAttributes.getString("name")));
            this.setPort(this.resolveProperty(this.locatorProperty("port"), (Integer)locatorApplicationAnnotationAttributes.getNumber("port")));
            this.setUseBeanFactoryLocator(this.resolveProperty("use-bean-factory-locator", Boolean.class, locatorApplicationAnnotationAttributes.getBoolean("useBeanFactoryLocator")));
            this.setUseClusterConfigurationService(this.resolveProperty(this.locatorProperty("use-cluster-configuration"), Boolean.class, locatorApplicationAnnotationAttributes.getBoolean("useClusterConfiguration")));
        }
    }

    @Bean
    public LocatorFactoryBean locatorApplication() {
        LocatorFactoryBean locatorFactoryBean = new LocatorFactoryBean();
        locatorFactoryBean.setBindAddress(this.getBindAddress());
        locatorFactoryBean.setHostnameForClients(this.getHostnameForClients());
        locatorFactoryBean.setLocatorConfigurers(this.resolveLocatorConfigurers());
        locatorFactoryBean.setLocators(this.getLocators());
        locatorFactoryBean.setLogLevel(this.getLogLevel());
        locatorFactoryBean.setName(this.getName());
        locatorFactoryBean.setPort(this.getPort());
        locatorFactoryBean.setUseBeanFactoryLocator(this.isUseBeanFactoryLocator());
        locatorFactoryBean.setUseClusterConfigurationService(this.isUseClusterConfigurationService());
        return locatorFactoryBean;
    }

    private List<LocatorConfigurer> resolveLocatorConfigurers() {
        return Optional.ofNullable(this.locatorConfigurers).filter(locatorConfigurers -> !locatorConfigurers.isEmpty()).orElseGet(() -> Collections.singletonList(LazyResolvingComposableLocatorConfigurer.create(this.getBeanFactory())));
    }

    public void setBindAddress(@Nullable String bindAddress) {
        this.bindAddress = bindAddress;
    }

    @Nullable
    public String getBindAddress() {
        return this.bindAddress;
    }

    public void setHostnameForClients(@Nullable String hostnameForClients) {
        this.hostnameForClients = hostnameForClients;
    }

    @Nullable
    public String getHostnameForClients() {
        return this.hostnameForClients;
    }

    public void setLocators(@Nullable String locators) {
        this.locators = locators;
    }

    @Nullable
    public String getLocators() {
        return this.locators;
    }

    public void setLogLevel(@Nullable String logLevel) {
        this.logLevel = logLevel;
    }

    @Nullable
    public String getLogLevel() {
        return this.logLevel;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isUseBeanFactoryLocator() {
        return this.useBeanFactoryLocator;
    }

    public void setUseBeanFactoryLocator(boolean useBeanFactoryLocator) {
        this.useBeanFactoryLocator = useBeanFactoryLocator;
    }

    public void setUseClusterConfigurationService(boolean useClusterConfigurationService) {
        this.useClusterConfigurationService = useClusterConfigurationService;
    }

    public boolean isUseClusterConfigurationService() {
        return this.useClusterConfigurationService;
    }
}

