/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractCacheManager;
import org.springframework.data.gemfire.cache.GemfireCache;
import org.springframework.util.Assert;

public class GemfireCacheManager
extends AbstractCacheManager {
    private final AtomicBoolean dynamic = new AtomicBoolean(true);
    private GemFireCache gemfireCache;
    private Set<Region<?, ?>> regions;
    private Set<String> cacheNames;

    <T extends GemFireCache> T assertGemFireCacheAvailable(T gemfireCache) {
        Assert.state((gemfireCache != null ? 1 : 0) != 0, (String)"A GemFire cache instance is required");
        Assert.state((!gemfireCache.isClosed() ? 1 : 0) != 0, (String)String.format("GemFire cache [%s] has been closed", gemfireCache.getName()));
        return gemfireCache;
    }

    Region<?, ?> assertGemFireRegionAvailable(Region<?, ?> region, String cacheName) {
        Assert.state((region != null ? 1 : 0) != 0, (String)String.format("No Region for cache name [%s] was found", cacheName));
        Assert.state((!region.isDestroyed() ? 1 : 0) != 0, (String)String.format("Region [%s] has been destroyed", cacheName));
        return region;
    }

    protected Collection<Cache> loadCaches() {
        Set<Region<?, ?>> regions = this.resolveRegions(this.gemfireCache, this.regions, this.cacheNames);
        HashSet<Cache> caches = new HashSet<Cache>(regions.size());
        for (Region<?, ?> region : regions) {
            caches.add(this.newGemfireCache(region));
        }
        return caches;
    }

    Set<Region<?, ?>> resolveRegions(GemFireCache gemfireCache, Set<Region<?, ?>> regions, Set<String> cacheNames) {
        if (this.isSet(regions)) {
            this.dynamic.set(false);
            return regions;
        }
        if (this.isSet(cacheNames)) {
            this.dynamic.set(false);
            regions = new HashSet(cacheNames.size());
            for (String cacheName : cacheNames) {
                regions.add(this.regionFor(gemfireCache, cacheName));
            }
            return regions;
        }
        return this.assertGemFireCacheAvailable(gemfireCache).rootRegions();
    }

    boolean isSet(Iterable<?> collection) {
        return collection != null && collection.iterator().hasNext();
    }

    protected GemfireCache newGemfireCache(Region<?, ?> region) {
        return GemfireCache.wrap(region);
    }

    Region<?, ?> regionFor(GemFireCache gemfireCache, String cacheName) {
        return this.assertGemFireRegionAvailable(this.assertGemFireCacheAvailable(gemfireCache).getRegion(cacheName), cacheName);
    }

    protected Cache getMissingCache(String name) {
        Cache cache = super.getMissingCache(name);
        return cache != null ? cache : (this.isDynamic() ? this.newGemfireCache(this.regionFor(this.gemfireCache, name)) : null);
    }

    protected boolean isDynamic() {
        return this.dynamic.get();
    }

    public void setCache(GemFireCache gemfireCache) {
        this.gemfireCache = gemfireCache;
    }

    protected GemFireCache getCache() {
        return this.gemfireCache;
    }

    public void setCacheNames(Set<String> cacheNames) {
        this.cacheNames = cacheNames;
    }

    public void setRegions(Set<Region<?, ?>> regions) {
        this.regions = regions;
    }

    protected Set<Region<?, ?>> getRegions() {
        return this.regions;
    }
}

