/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.util.concurrent.atomic.AtomicReference;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public abstract class JavaVersion
implements Comparable<JavaVersion> {
    public static final JavaVersion ONE_ZERO = JavaVersion.of(1, 0, 0);
    public static final JavaVersion ONE_ONE = JavaVersion.of(1, 1, 0);
    public static final JavaVersion ONE_TWO = JavaVersion.of(1, 2, 0);
    public static final JavaVersion ONE_THREE = JavaVersion.of(1, 3, 0);
    public static final JavaVersion ONE_FOUR = JavaVersion.of(1, 4, 0);
    public static final JavaVersion FIVE = JavaVersion.of(1, 5, 0);
    public static final JavaVersion SIX = JavaVersion.of(1, 6, 0);
    public static final JavaVersion SEVEN = JavaVersion.of(1, 7, 0);
    public static final JavaVersion EIGHT = JavaVersion.of(1, 8, 0);
    public static final JavaVersion NINE = JavaVersion.of(9, 0, 0);
    public static final JavaVersion TEN = JavaVersion.of(10, 0, 0);
    public static final JavaVersion ELEVEN = JavaVersion.of(11, 0, 0);
    public static final JavaVersion TWELVE = JavaVersion.of(12, 0, 0);
    public static final JavaVersion THIRTEEN = JavaVersion.of(13, 0, 0);
    public static final JavaVersion FOURTEEN = JavaVersion.of(14, 0, 0);
    public static final JavaVersion FIFTEEN = JavaVersion.of(15, 0, 0);
    public static final JavaVersion SIXTEEN = JavaVersion.of(16, 0, 0);
    public static final JavaVersion SEVENTEEN = JavaVersion.of(17, 0, 0);
    protected static final int DEFAULT_VERSION_NUMBER = 0;
    protected static final int DEFAULT_BUILD_NUMBER = 0;
    protected static final int DEFAULT_PATCH_VERSION = 0;
    protected static final Integer ZERO = 0;
    protected static final String JAVA_VERSION_SYSTEM_PROPERTY = "java.version";
    private static final AtomicReference<JavaVersion> CURRENT = new AtomicReference<Object>(null);
    private final Integer buildNumber;
    private final Integer major;
    private final Integer minor;
    private final Integer patch;

    public static JavaVersion current() {
        return CURRENT.updateAndGet(currentJavaVersion -> currentJavaVersion != null ? currentJavaVersion : JavaVersion.determineCurrentJavaVersion());
    }

    protected static JavaVersion of(int major, int minor, int patch) {
        return new JavaVersion(major, minor, patch){};
    }

    private static JavaVersion determineCurrentJavaVersion() {
        String javaVersion = String.valueOf(System.getProperty(JAVA_VERSION_SYSTEM_PROPERTY));
        String[] javaVersionArray = ArrayUtils.nullSafeArray(javaVersion.split("\\."), String.class);
        int major = 0;
        int minor = 0;
        int patch = 0;
        if (javaVersionArray.length > 0) {
            major = JavaVersion.parseInt(javaVersionArray[0]);
            if (javaVersionArray.length > 1) {
                minor = JavaVersion.parseInt(javaVersionArray[1]);
                if (javaVersionArray.length > 2) {
                    String tempPatch = javaVersionArray[2];
                    tempPatch = tempPatch.contains("_") ? tempPatch.substring(0, tempPatch.indexOf("_")) : tempPatch;
                    patch = JavaVersion.parseInt(tempPatch);
                }
            }
        }
        return JavaVersion.of(major, minor, patch);
    }

    private static String parseDigits(String value) {
        StringBuilder digits = new StringBuilder();
        for (char character : String.valueOf(value).toCharArray()) {
            if (!Character.isDigit(character)) continue;
            digits.append(character);
        }
        return digits.toString();
    }

    private static int parseInt(String value) {
        try {
            return Integer.parseInt(JavaVersion.parseDigits(value));
        }
        catch (NumberFormatException ignore) {
            return 0;
        }
    }

    protected JavaVersion(int major, int minor) {
        this(major, minor, 0);
    }

    protected JavaVersion(int major, int minor, int patch) {
        this(major, minor, patch, 0);
    }

    protected JavaVersion(int major, int minor, int patch, int buildNumber) {
        this.major = this.validateVersionNumber(major);
        this.minor = this.validateVersionNumber(minor);
        this.patch = this.validateVersionNumber(patch);
        this.buildNumber = buildNumber;
    }

    private int validateVersionNumber(int version) {
        Assert.isTrue((version > -1 ? 1 : 0) != 0, () -> String.format("Version number [%d] must be greater than equal to 0", version));
        return version;
    }

    public boolean isJava8() {
        return EIGHT.getMajor().equals(this.getMajor()) && EIGHT.getMinor().equals(this.getMinor());
    }

    public boolean isJava11() {
        return ELEVEN.getMajor().equals(this.getMajor());
    }

    public boolean isJava17() {
        return SEVENTEEN.getMajor().equals(this.getMajor());
    }

    public boolean isNewerThanOrEqualTo(@Nullable JavaVersion javaVersion) {
        return javaVersion != null && this.compareTo(javaVersion) >= 0;
    }

    public boolean isOlderThan(@Nullable JavaVersion javaVersion) {
        return javaVersion != null && this.compareTo(javaVersion) < 0;
    }

    public boolean isUndetermined() {
        return ZERO.equals(this.getMajor()) && ZERO.equals(this.getMinor()) && ZERO.equals(this.getPatch());
    }

    @NonNull
    public Integer getMajor() {
        return this.major;
    }

    @NonNull
    public Integer getMinor() {
        return this.minor;
    }

    @NonNull
    public Integer getPatch() {
        return this.patch;
    }

    @NonNull
    public Integer getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    public int compareTo(@NonNull JavaVersion version) {
        int result = this.getMajor().compareTo(version.getMajor());
        result = result != 0 ? result : this.getMinor().compareTo(version.getMinor());
        result = result != 0 ? result : this.getPatch().compareTo(version.getPatch());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JavaVersion)) {
            return false;
        }
        JavaVersion that = (JavaVersion)obj;
        return this.getMajor().equals(that.getMajor()) && this.getMinor().equals(that.getMinor()) && this.getPatch().equals(that.getPatch());
    }

    public int hashCode() {
        int hashValue = 17;
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getMajor());
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getMinor());
        hashValue = 37 * hashValue + ObjectUtils.nullSafeHashCode((Object)this.getPatch());
        return hashValue;
    }

    @NonNull
    public String toString() {
        return String.format("%1$s.%2$s.%3$s", this.getMajor(), this.getMinor(), this.getPatch());
    }
}

