/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Arrays;
import java.util.function.Supplier;
import org.apache.geode.cache.GemFireCache;
import org.springframework.data.gemfire.CacheResolver;
import org.springframework.data.gemfire.support.AbstractCachingCacheResolver;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ComposableCacheResolver<T extends GemFireCache>
extends AbstractCachingCacheResolver<T> {
    private final CacheResolver<T> cacheResolverOne;
    private final CacheResolver<T> cacheResolverTwo;

    @Nullable
    public static <T extends GemFireCache> CacheResolver<T> compose(CacheResolver<T> ... cacheResolvers) {
        return ComposableCacheResolver.compose(Arrays.asList(ArrayUtils.nullSafeArray(cacheResolvers, CacheResolver.class)));
    }

    @Nullable
    public static <T extends GemFireCache> CacheResolver<T> compose(@Nullable Iterable<CacheResolver<T>> cacheResolvers) {
        CacheResolver<T> current = null;
        for (CacheResolver<T> cacheResolver : CollectionUtils.nullSafeIterable(cacheResolvers)) {
            current = ComposableCacheResolver.compose(current, cacheResolver);
        }
        return current;
    }

    @Nullable
    public static <T extends GemFireCache> CacheResolver<T> compose(@Nullable CacheResolver<T> one, @Nullable CacheResolver<T> two) {
        return one == null ? two : (two == null ? one : new ComposableCacheResolver<T>(one, two));
    }

    protected ComposableCacheResolver(@NonNull CacheResolver<T> cacheResolverOne, @NonNull CacheResolver<T> cacheResolverTwo) {
        Assert.notNull(cacheResolverOne, (String)"CacheResolver 1 must not be null");
        Assert.notNull(cacheResolverTwo, (String)"CacheResolver 2 must not be null");
        this.cacheResolverOne = cacheResolverOne;
        this.cacheResolverTwo = cacheResolverTwo;
    }

    @NonNull
    protected CacheResolver<T> getCacheResolverOne() {
        return this.cacheResolverOne;
    }

    @NonNull
    protected CacheResolver<T> getCacheResolverTwo() {
        return this.cacheResolverTwo;
    }

    @Override
    public T doResolve() {
        Supplier<GemFireCache> cacheSupplier = () -> this.getCacheResolverTwo().resolve();
        try {
            T cache = this.getCacheResolverOne().resolve();
            return (T)(cache != null ? cache : cacheSupplier.get());
        }
        catch (Throwable ignore) {
            return (T)cacheSupplier.get();
        }
    }
}

