/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.snapshot.event;

import org.apache.geode.cache.Region;
import org.springframework.context.ApplicationEvent;
import org.springframework.data.gemfire.snapshot.SnapshotServiceFactoryBean;
import org.springframework.util.StringUtils;

public abstract class SnapshotApplicationEvent<K, V>
extends ApplicationEvent {
    private final SnapshotServiceFactoryBean.SnapshotMetadata<K, V>[] snapshotMetadata;
    private final String regionPath;

    public SnapshotApplicationEvent(Object source, SnapshotServiceFactoryBean.SnapshotMetadata<K, V> ... snapshotMetadata) {
        this(source, (String)null, snapshotMetadata);
    }

    public SnapshotApplicationEvent(Object source, String regionPath, SnapshotServiceFactoryBean.SnapshotMetadata<K, V> ... snapshotMetadata) {
        super(source);
        this.snapshotMetadata = snapshotMetadata;
        this.regionPath = regionPath;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    public SnapshotServiceFactoryBean.SnapshotMetadata<K, V>[] getSnapshotMetadata() {
        return this.snapshotMetadata;
    }

    public boolean isCacheSnapshotEvent() {
        return !this.isRegionSnapshotEvent();
    }

    public boolean isRegionSnapshotEvent() {
        return StringUtils.hasText((String)this.getRegionPath());
    }

    public boolean matches(Region region) {
        return region != null && this.matches(region.getFullPath());
    }

    public boolean matches(String regionPath) {
        return this.toString(regionPath).equals(this.toString(this.getRegionPath()));
    }

    private String toString(String value) {
        return String.valueOf(value).trim();
    }
}

