/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.envers.repository.support;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Optional;
import org.hibernate.envers.DefaultRevisionEntity;
import org.springframework.data.history.RevisionMetadata;
import org.springframework.util.Assert;

public final class DefaultRevisionMetadata
implements RevisionMetadata<Integer> {
    private final DefaultRevisionEntity entity;
    private final RevisionMetadata.RevisionType revisionType;

    public DefaultRevisionMetadata(DefaultRevisionEntity entity) {
        this(entity, RevisionMetadata.RevisionType.UNKNOWN);
    }

    public DefaultRevisionMetadata(DefaultRevisionEntity entity, RevisionMetadata.RevisionType revisionType) {
        Assert.notNull((Object)entity, (String)"DefaultRevisionEntity must not be null");
        this.entity = entity;
        this.revisionType = revisionType;
    }

    public Optional<Integer> getRevisionNumber() {
        return Optional.of(this.entity.getId());
    }

    @Deprecated
    public Optional<LocalDateTime> getRevisionDate() {
        return this.getRevisionInstant().map(instant -> LocalDateTime.ofInstant(instant, ZoneOffset.systemDefault()));
    }

    public Optional<Instant> getRevisionInstant() {
        return Optional.of(Instant.ofEpochMilli(this.entity.getTimestamp()));
    }

    public <T> T getDelegate() {
        return (T)this.entity;
    }

    public RevisionMetadata.RevisionType getRevisionType() {
        return this.revisionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultRevisionMetadata that = (DefaultRevisionMetadata)o;
        return this.getRevisionNumber().equals(that.getRevisionNumber()) && this.getRevisionInstant().equals(that.getRevisionInstant()) && this.revisionType.equals((Object)that.getRevisionType());
    }

    public String toString() {
        return "DefaultRevisionMetadata{entity=" + this.entity + ", revisionType=" + this.revisionType + "}";
    }
}

