/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.index;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Iterator;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.data.annotation.Transient;
import org.springframework.data.elasticsearch.ElasticsearchException;
import org.springframework.data.elasticsearch.annotations.CompletionContext;
import org.springframework.data.elasticsearch.annotations.CompletionField;
import org.springframework.data.elasticsearch.annotations.DynamicMapping;
import org.springframework.data.elasticsearch.annotations.DynamicTemplates;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;
import org.springframework.data.elasticsearch.annotations.GeoShapeField;
import org.springframework.data.elasticsearch.annotations.InnerField;
import org.springframework.data.elasticsearch.annotations.JoinTypeRelation;
import org.springframework.data.elasticsearch.annotations.JoinTypeRelations;
import org.springframework.data.elasticsearch.annotations.Mapping;
import org.springframework.data.elasticsearch.annotations.MultiField;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.ResourceUtil;
import org.springframework.data.elasticsearch.core.convert.ElasticsearchConverter;
import org.springframework.data.elasticsearch.core.index.GeoShapeMappingParameters;
import org.springframework.data.elasticsearch.core.index.MappingParameters;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentEntity;
import org.springframework.data.elasticsearch.core.mapping.ElasticsearchPersistentProperty;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class MappingBuilder {
    private static final String FIELD_INDEX = "index";
    private static final String FIELD_PROPERTIES = "properties";
    @Deprecated
    private static final String FIELD_PARENT = "_parent";
    private static final String FIELD_CONTEXT_NAME = "name";
    private static final String FIELD_CONTEXT_TYPE = "type";
    private static final String FIELD_CONTEXT_PATH = "path";
    private static final String FIELD_CONTEXT_PRECISION = "precision";
    private static final String FIELD_DYNAMIC_TEMPLATES = "dynamic_templates";
    private static final String COMPLETION_PRESERVE_SEPARATORS = "preserve_separators";
    private static final String COMPLETION_PRESERVE_POSITION_INCREMENTS = "preserve_position_increments";
    private static final String COMPLETION_MAX_INPUT_LENGTH = "max_input_length";
    private static final String COMPLETION_CONTEXTS = "contexts";
    private static final String TYPE_DYNAMIC = "dynamic";
    private static final String TYPE_VALUE_KEYWORD = "keyword";
    private static final String TYPE_VALUE_GEO_POINT = "geo_point";
    private static final String TYPE_VALUE_JOIN = "join";
    private static final String TYPE_VALUE_COMPLETION = "completion";
    private static final String JOIN_TYPE_RELATIONS = "relations";
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchRestTemplate.class);
    private final ElasticsearchConverter elasticsearchConverter;

    public MappingBuilder(ElasticsearchConverter elasticsearchConverter) {
        this.elasticsearchConverter = elasticsearchConverter;
    }

    public String buildPropertyMapping(Class<?> clazz) throws ElasticsearchException {
        try {
            ElasticsearchPersistentEntity entity = (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getRequiredPersistentEntity(clazz);
            XContentBuilder builder = XContentFactory.jsonBuilder().startObject();
            this.addDynamicTemplatesMapping(builder, entity);
            String parentType = entity.getParentType();
            if (StringUtils.hasText((String)parentType)) {
                builder.startObject(FIELD_PARENT).field(FIELD_CONTEXT_TYPE, parentType).endObject();
            }
            this.mapEntity(builder, entity, true, "", false, FieldType.Auto, null, (DynamicMapping)entity.findAnnotation(DynamicMapping.class));
            builder.endObject().close();
            return builder.getOutputStream().toString();
        }
        catch (IOException | MappingException e) {
            throw new ElasticsearchException("could not build mapping", e);
        }
    }

    private void mapEntity(XContentBuilder builder, @Nullable ElasticsearchPersistentEntity<?> entity, boolean isRootObject, String nestedObjectFieldName, boolean nestedOrObjectField, FieldType fieldType, @Nullable Field parentFieldAnnotation, @Nullable DynamicMapping dynamicMapping) throws IOException {
        boolean writeNestedProperties;
        boolean bl = writeNestedProperties = !isRootObject && (this.isAnyPropertyAnnotatedWithField(entity) || nestedOrObjectField);
        if (writeNestedProperties) {
            String type = nestedOrObjectField ? fieldType.toString().toLowerCase() : FieldType.Object.toString().toLowerCase();
            builder.startObject(nestedObjectFieldName).field(FIELD_CONTEXT_TYPE, type);
            if (nestedOrObjectField && FieldType.Nested == fieldType && parentFieldAnnotation != null && parentFieldAnnotation.includeInParent()) {
                builder.field("include_in_parent", true);
            }
        }
        if (dynamicMapping != null) {
            builder.field(TYPE_DYNAMIC, dynamicMapping.value().name().toLowerCase());
        }
        builder.startObject(FIELD_PROPERTIES);
        if (entity != null) {
            entity.doWithProperties(property -> {
                try {
                    if (property.isAnnotationPresent(Transient.class) || this.isInIgnoreFields((ElasticsearchPersistentProperty)property, parentFieldAnnotation)) {
                        return;
                    }
                    if (property.isSeqNoPrimaryTermProperty()) {
                        if (property.isAnnotationPresent(Field.class)) {
                            logger.warn("Property {} of {} is annotated for inclusion in mapping, but its type is SeqNoPrimaryTerm that is never mapped, so it is skipped", (Object)property.getFieldName(), (Object)entity.getType());
                        }
                        return;
                    }
                    this.buildPropertyMapping(builder, isRootObject, (ElasticsearchPersistentProperty)property);
                }
                catch (IOException e) {
                    logger.warn("error mapping property with name {}", (Object)property.getName(), (Object)e);
                }
            });
        }
        builder.endObject();
        if (writeNestedProperties) {
            builder.endObject();
        }
    }

    private void buildPropertyMapping(XContentBuilder builder, boolean isRootObject, ElasticsearchPersistentProperty property) throws IOException {
        ClassPathResource mappings;
        String mappingPath;
        if (property.isAnnotationPresent(Mapping.class) && !StringUtils.isEmpty((Object)(mappingPath = ((Mapping)property.getRequiredAnnotation(Mapping.class)).mappingPath())) && (mappings = new ClassPathResource(mappingPath)).exists()) {
            builder.rawField(property.getFieldName(), mappings.getInputStream(), XContentType.JSON);
            return;
        }
        if (property.isGeoPointProperty()) {
            this.applyGeoPointFieldMapping(builder, property);
            return;
        }
        if (property.isGeoShapeProperty()) {
            this.applyGeoShapeMapping(builder, property);
        }
        if (property.isJoinFieldProperty()) {
            this.addJoinFieldMapping(builder, property);
        }
        Field fieldAnnotation = (Field)property.findAnnotation(Field.class);
        boolean isCompletionProperty = property.isCompletionProperty();
        boolean isNestedOrObjectProperty = this.isNestedOrObjectProperty(property);
        DynamicMapping dynamicMapping = (DynamicMapping)property.findAnnotation(DynamicMapping.class);
        if (!isCompletionProperty && property.isEntity() && this.hasRelevantAnnotation(property)) {
            if (fieldAnnotation == null) {
                return;
            }
            if (isNestedOrObjectProperty) {
                Iterator iterator = property.getPersistentEntityTypes().iterator();
                ElasticsearchPersistentEntity persistentEntity = iterator.hasNext() ? (ElasticsearchPersistentEntity)this.elasticsearchConverter.getMappingContext().getPersistentEntity((TypeInformation)iterator.next()) : null;
                this.mapEntity(builder, persistentEntity, false, property.getFieldName(), true, fieldAnnotation.type(), fieldAnnotation, dynamicMapping);
                return;
            }
        }
        MultiField multiField = (MultiField)property.findAnnotation(MultiField.class);
        if (isCompletionProperty) {
            CompletionField completionField = (CompletionField)property.findAnnotation(CompletionField.class);
            this.applyCompletionFieldMapping(builder, property, completionField);
        }
        if (isRootObject && fieldAnnotation != null && property.isIdProperty()) {
            this.applyDefaultIdFieldMapping(builder, property);
        } else if (multiField != null) {
            this.addMultiFieldMapping(builder, property, multiField, isNestedOrObjectProperty, dynamicMapping);
        } else if (fieldAnnotation != null) {
            this.addSingleFieldMapping(builder, property, fieldAnnotation, isNestedOrObjectProperty, dynamicMapping);
        }
    }

    private boolean hasRelevantAnnotation(ElasticsearchPersistentProperty property) {
        return property.findAnnotation(Field.class) != null || property.findAnnotation(MultiField.class) != null || property.findAnnotation(GeoPointField.class) != null || property.findAnnotation(CompletionField.class) != null;
    }

    private void applyGeoPointFieldMapping(XContentBuilder builder, ElasticsearchPersistentProperty property) throws IOException {
        builder.startObject(property.getFieldName()).field(FIELD_CONTEXT_TYPE, TYPE_VALUE_GEO_POINT).endObject();
    }

    private void applyGeoShapeMapping(XContentBuilder builder, ElasticsearchPersistentProperty property) throws IOException {
        builder.startObject(property.getFieldName());
        GeoShapeMappingParameters.from((GeoShapeField)property.findAnnotation(GeoShapeField.class)).writeTypeAndParametersTo(builder);
        builder.endObject();
    }

    private void applyCompletionFieldMapping(XContentBuilder builder, ElasticsearchPersistentProperty property, @Nullable CompletionField annotation) throws IOException {
        builder.startObject(property.getFieldName());
        builder.field(FIELD_CONTEXT_TYPE, TYPE_VALUE_COMPLETION);
        if (annotation != null) {
            builder.field(COMPLETION_MAX_INPUT_LENGTH, annotation.maxInputLength());
            builder.field(COMPLETION_PRESERVE_POSITION_INCREMENTS, annotation.preservePositionIncrements());
            builder.field(COMPLETION_PRESERVE_SEPARATORS, annotation.preserveSeparators());
            if (!StringUtils.isEmpty((Object)annotation.searchAnalyzer())) {
                builder.field("search_analyzer", annotation.searchAnalyzer());
            }
            if (!StringUtils.isEmpty((Object)annotation.analyzer())) {
                builder.field("analyzer", annotation.analyzer());
            }
            if (annotation.contexts().length > 0) {
                builder.startArray(COMPLETION_CONTEXTS);
                for (CompletionContext context : annotation.contexts()) {
                    builder.startObject();
                    builder.field(FIELD_CONTEXT_NAME, context.name());
                    builder.field(FIELD_CONTEXT_TYPE, context.type().name().toLowerCase());
                    if (context.precision().length() > 0) {
                        builder.field(FIELD_CONTEXT_PRECISION, context.precision());
                    }
                    if (StringUtils.hasText((String)context.path())) {
                        builder.field(FIELD_CONTEXT_PATH, context.path());
                    }
                    builder.endObject();
                }
                builder.endArray();
            }
        }
        builder.endObject();
    }

    private void applyDefaultIdFieldMapping(XContentBuilder builder, ElasticsearchPersistentProperty property) throws IOException {
        builder.startObject(property.getFieldName()).field(FIELD_CONTEXT_TYPE, TYPE_VALUE_KEYWORD).field(FIELD_INDEX, true).endObject();
    }

    private void addSingleFieldMapping(XContentBuilder builder, ElasticsearchPersistentProperty property, Field annotation, boolean nestedOrObjectField, @Nullable DynamicMapping dynamicMapping) throws IOException {
        XContentBuilder propertyBuilder = XContentFactory.jsonBuilder().startObject();
        this.addFieldMappingParameters(propertyBuilder, annotation, nestedOrObjectField);
        propertyBuilder.endObject().close();
        if ("{}".equals(propertyBuilder.getOutputStream().toString())) {
            return;
        }
        builder.startObject(property.getFieldName());
        if (nestedOrObjectField && dynamicMapping != null) {
            builder.field(TYPE_DYNAMIC, dynamicMapping.value().name().toLowerCase());
        }
        this.addFieldMappingParameters(builder, annotation, nestedOrObjectField);
        builder.endObject();
    }

    private void addJoinFieldMapping(XContentBuilder builder, ElasticsearchPersistentProperty property) throws IOException {
        JoinTypeRelation[] joinTypeRelations = ((JoinTypeRelations)property.getRequiredAnnotation(JoinTypeRelations.class)).relations();
        if (joinTypeRelations.length == 0) {
            logger.warn("Property {}s type is JoinField but its annotation JoinTypeRelation is not properly maintained", (Object)property.getFieldName());
            return;
        }
        builder.startObject(property.getFieldName());
        builder.field(FIELD_CONTEXT_TYPE, TYPE_VALUE_JOIN);
        builder.startObject(JOIN_TYPE_RELATIONS);
        for (JoinTypeRelation joinTypeRelation : joinTypeRelations) {
            String parent = joinTypeRelation.parent();
            String[] children = joinTypeRelation.children();
            if (children.length > 1) {
                builder.array(parent, children);
                continue;
            }
            if (children.length != 1) continue;
            builder.field(parent, children[0]);
        }
        builder.endObject();
        builder.endObject();
    }

    private void addMultiFieldMapping(XContentBuilder builder, ElasticsearchPersistentProperty property, MultiField annotation, boolean nestedOrObjectField, @Nullable DynamicMapping dynamicMapping) throws IOException {
        builder.startObject(property.getFieldName());
        if (nestedOrObjectField && dynamicMapping != null) {
            builder.field(TYPE_DYNAMIC, dynamicMapping.value().name().toLowerCase());
        }
        this.addFieldMappingParameters(builder, annotation.mainField(), nestedOrObjectField);
        builder.startObject("fields");
        for (InnerField innerField : annotation.otherFields()) {
            builder.startObject(innerField.suffix());
            this.addFieldMappingParameters(builder, innerField, false);
            builder.endObject();
        }
        builder.endObject();
        builder.endObject();
    }

    private void addFieldMappingParameters(XContentBuilder builder, Annotation annotation, boolean nestedOrObjectField) throws IOException {
        MappingParameters mappingParameters = MappingParameters.from(annotation);
        if (!nestedOrObjectField && mappingParameters.isStore()) {
            builder.field("store", true);
        }
        mappingParameters.writeTypeAndParametersTo(builder);
    }

    private void addDynamicTemplatesMapping(XContentBuilder builder, ElasticsearchPersistentEntity<?> entity) throws IOException {
        ObjectMapper objectMapper;
        JsonNode jsonNode;
        String jsonString;
        String mappingPath;
        if (entity.isAnnotationPresent(DynamicTemplates.class) && StringUtils.hasText((String)(mappingPath = ((DynamicTemplates)entity.getRequiredAnnotation(DynamicTemplates.class)).mappingPath())) && StringUtils.hasText((String)(jsonString = ResourceUtil.readFileFromClasspath(mappingPath))) && (jsonNode = (objectMapper = new ObjectMapper()).readTree(jsonString).get(FIELD_DYNAMIC_TEMPLATES)) != null && jsonNode.isArray()) {
            String json = objectMapper.writeValueAsString((Object)jsonNode);
            builder.rawField(FIELD_DYNAMIC_TEMPLATES, (InputStream)new ByteArrayInputStream(json.getBytes()), XContentType.JSON);
        }
    }

    private boolean isAnyPropertyAnnotatedWithField(@Nullable ElasticsearchPersistentEntity entity) {
        return entity != null && entity.getPersistentProperty(Field.class) != null;
    }

    private boolean isInIgnoreFields(ElasticsearchPersistentProperty property, @Nullable Field parentFieldAnnotation) {
        if (null != parentFieldAnnotation) {
            String[] ignoreFields = parentFieldAnnotation.ignoreFields();
            return Arrays.asList(ignoreFields).contains(property.getFieldName());
        }
        return false;
    }

    private boolean isNestedOrObjectProperty(ElasticsearchPersistentProperty property) {
        Field fieldAnnotation = (Field)property.findAnnotation(Field.class);
        return fieldAnnotation != null && (FieldType.Nested == fieldAnnotation.type() || FieldType.Object == fieldAnnotation.type());
    }
}

