/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.util.Assert;

@ReadingConverter
public class BooleanToEnumConverterFactory
implements ConverterFactory<Boolean, Enum> {
    private final ObjectMapper objectMapper;

    public BooleanToEnumConverterFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public <T extends Enum> Converter<Boolean, T> getConverter(Class<T> targetType) {
        return new BooleanToEnum(BooleanToEnumConverterFactory.getEnumType(targetType), this.objectMapper);
    }

    public static Class<?> getEnumType(Class<?> targetType) {
        Class<?> enumType;
        for (enumType = targetType; enumType != null && !enumType.isEnum(); enumType = enumType.getSuperclass()) {
        }
        Assert.notNull(enumType, () -> "The target type " + targetType.getName() + " does not refer to an enum");
        return enumType;
    }

    private static class BooleanToEnum<T extends Enum>
    implements Converter<Boolean, T> {
        private final Class<T> enumType;
        private final ObjectMapper objectMapper;

        BooleanToEnum(Class<T> enumType, ObjectMapper objectMapper) {
            this.enumType = enumType;
            this.objectMapper = objectMapper;
        }

        public @Nullable T convert(Boolean source) {
            if (source == null) {
                return null;
            }
            try {
                return (T)((Enum)this.objectMapper.readValue("\"" + source + "\"", this.enumType));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

