/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.api.query.CoreQueryContext;
import com.couchbase.client.core.api.query.CoreQueryOptions;
import com.couchbase.client.java.ReactiveScope;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import com.couchbase.client.java.query.ReactiveQueryResult;
import com.couchbase.client.java.transactions.TransactionQueryOptions;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.CouchbaseClientFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveRemoveByQueryOperation;
import org.springframework.data.couchbase.core.RemoveResult;
import org.springframework.data.couchbase.core.TransactionalSupport;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.data.couchbase.transaction.CouchbaseResourceHolder;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;

public class ReactiveRemoveByQueryOperationSupport
implements ReactiveRemoveByQueryOperation {
    private static final Query ALL_QUERY = new Query();
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveRemoveByQueryOperationSupport.class);

    public ReactiveRemoveByQueryOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveRemoveByQueryOperation.ReactiveRemoveByQuery<T> removeByQuery(Class<T> domainType) {
        return new ReactiveRemoveByQuerySupport<T>(this.template, domainType, ALL_QUERY, null, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null);
    }

    static class ReactiveRemoveByQuerySupport<T>
    implements ReactiveRemoveByQueryOperation.ReactiveRemoveByQuery<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final Query query;
        private final QueryScanConsistency scanConsistency;
        private final String scope;
        private final String collection;
        private final QueryOptions options;

        ReactiveRemoveByQuerySupport(ReactiveCouchbaseTemplate template, Class<T> domainType, Query query, QueryScanConsistency scanConsistency, String scope, String collection, QueryOptions options) {
            this.template = template;
            this.domainType = domainType;
            this.query = query;
            this.scanConsistency = scanConsistency;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
        }

        @Override
        public Flux<RemoveResult> all() {
            PseudoArgs<QueryOptions> pArgs = new PseudoArgs<QueryOptions>(this.template, this.scope, this.collection, this.options, this.domainType);
            String statement = this.assembleDeleteQuery(pArgs.getScope(), pArgs.getCollection());
            if (LOG.isDebugEnabled()) {
                LOG.debug("removeByQuery {} statement: {}", pArgs, (Object)statement);
            }
            CouchbaseClientFactory clientFactory = this.template.getCouchbaseClientFactory();
            ReactiveScope rs = clientFactory.withScope(pArgs.getScope()).getScope().reactive();
            return TransactionalSupport.checkForTransactionInThreadLocalStorage().flatMapMany(transactionContext -> {
                if (!transactionContext.isPresent()) {
                    QueryOptions opts = this.buildQueryOptions((QueryOptions)pArgs.getOptions());
                    return (pArgs.getScope() == null ? clientFactory.getCluster().reactive().query(statement, opts) : rs.query(statement, opts)).flatMapMany(ReactiveQueryResult::rowsAsObject).map(row -> new RemoveResult(row.getString("__id"), row.getLong("__cas"), Optional.empty()));
                }
                TransactionQueryOptions opts = OptionsBuilder.buildTransactionQueryOptions(this.buildQueryOptions((QueryOptions)pArgs.getOptions()));
                CoreQueryContext queryContext = OptionsBuilder.queryContext(pArgs.getScope(), pArgs.getCollection(), rs.bucketName());
                return ((CouchbaseResourceHolder)((Object)((Object)transactionContext.get()))).getCore().queryBlocking(statement, queryContext, (CoreQueryOptions)opts.builder().build(), false).flatMapIterable(result -> result.collectRows()).map(row -> {
                    JsonObject json = JsonObject.fromJson((byte[])row.data());
                    return new RemoveResult(json.getString("__id"), json.getLong("__cas"), Optional.empty());
                });
            });
        }

        private QueryOptions buildQueryOptions(QueryOptions options) {
            QueryScanConsistency qsc = this.scanConsistency != null ? this.scanConsistency : this.template.getConsistency();
            return this.query.buildQueryOptions(options, qsc);
        }

        @Override
        public ReactiveRemoveByQueryOperation.TerminatingRemoveByQuery<T> matching(Query query) {
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, query, this.scanConsistency, this.scope, this.collection, this.options);
        }

        @Override
        public ReactiveRemoveByQueryOperation.RemoveByQueryWithConsistency<T> inCollection(String collection) {
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, this.scanConsistency, this.scope, collection != null ? collection : this.collection, this.options);
        }

        @Override
        @Deprecated
        public ReactiveRemoveByQueryOperation.RemoveByQueryInScope<T> consistentWith(QueryScanConsistency scanConsistency) {
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency, this.scope, this.collection, this.options);
        }

        @Override
        public ReactiveRemoveByQueryOperation.RemoveByQueryConsistentWith<T> withConsistency(QueryScanConsistency scanConsistency) {
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, scanConsistency, this.scope, this.collection, this.options);
        }

        private String assembleDeleteQuery(String scope, String collection) {
            return this.query.toN1qlRemoveString(this.template.getConverter(), this.template.getBucketName(), scope, collection, this.domainType);
        }

        @Override
        public ReactiveRemoveByQueryOperation.RemoveByQueryWithQuery<T> withOptions(QueryOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, this.scanConsistency, this.scope, this.collection, options);
        }

        @Override
        public ReactiveRemoveByQueryOperation.RemoveByQueryInCollection<T> inScope(String scope) {
            return new ReactiveRemoveByQuerySupport<T>(this.template, this.domainType, this.query, this.scanConsistency, scope != null ? scope : this.scope, this.collection, this.options);
        }
    }
}

