/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.cache;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import org.springframework.cache.Cache;
import org.springframework.cache.support.AbstractValueAdaptingCache;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.couchbase.cache.CouchbaseCacheConfiguration;
import org.springframework.data.couchbase.cache.CouchbaseCacheWriter;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class CouchbaseCache
extends AbstractValueAdaptingCache {
    private final String name;
    private final CouchbaseCacheWriter cacheWriter;
    private final CouchbaseCacheConfiguration cacheConfig;
    private final ConversionService conversionService;

    protected CouchbaseCache(String name, CouchbaseCacheWriter cacheWriter, CouchbaseCacheConfiguration cacheConfig) {
        super(cacheConfig.getAllowCacheNullValues());
        Assert.notNull((Object)name, (String)"Name must not be null!");
        Assert.notNull((Object)cacheWriter, (String)"CacheWriter must not be null!");
        Assert.notNull((Object)cacheConfig, (String)"CacheConfig must not be null!");
        this.name = name;
        this.cacheWriter = cacheWriter;
        this.cacheConfig = cacheConfig;
        this.conversionService = cacheConfig.getConversionService();
    }

    private static <T> T valueFromLoader(Object key, Callable<T> valueLoader) {
        try {
            return valueLoader.call();
        }
        catch (Exception e) {
            throw new Cache.ValueRetrievalException(key, valueLoader, (Throwable)e);
        }
    }

    public String getName() {
        return this.name;
    }

    public CouchbaseCacheWriter getNativeCache() {
        return this.cacheWriter;
    }

    protected Object lookup(Object key, Class<?> clazz) {
        return this.cacheWriter.get(this.cacheConfig.getCollectionName(), this.createCacheKey(key), this.cacheConfig.getValueTranscoder(), clazz);
    }

    protected Object lookup(Object key) {
        return this.lookup(key, Object.class);
    }

    public CouchbaseCacheConfiguration getCacheConfiguration() {
        return this.cacheConfig;
    }

    public synchronized <T> T get(Object key, Callable<T> valueLoader) {
        Cache.ValueWrapper result = this.get(key);
        if (result != null) {
            return (T)result.get();
        }
        T value = CouchbaseCache.valueFromLoader(key, valueLoader);
        this.put(key, value);
        return value;
    }

    public <T> T get(Object key, Class<T> type) {
        Object value = this.fromStoreValue(this.lookup(key, type));
        if (value != null && type != null && !type.isInstance(value)) {
            throw new IllegalStateException("Cached value is not of required type [" + type.getName() + "]: " + value);
        }
        return (T)value;
    }

    public synchronized <T> T get(Object key, Callable<T> valueLoader, Class<T> type) {
        T value = this.get(key, type);
        if (value == null) {
            value = CouchbaseCache.valueFromLoader(key, valueLoader);
            this.put(key, value);
        }
        return value;
    }

    public void put(Object key, Object value) {
        this.cacheWriter.put(this.cacheConfig.getCollectionName(), this.createCacheKey(key), this.toStoreValue(value), this.cacheConfig.getExpiry(), this.cacheConfig.getValueTranscoder());
    }

    public Cache.ValueWrapper putIfAbsent(Object key, Object value) {
        Object result = this.cacheWriter.putIfAbsent(this.cacheConfig.getCollectionName(), this.createCacheKey(key), this.toStoreValue(value), this.cacheConfig.getExpiry(), this.cacheConfig.getValueTranscoder());
        return this.toValueWrapper(result);
    }

    public <T> T putIfAbsent(Object key, Object value, Class<T> clazz) {
        Object result = this.cacheWriter.putIfAbsent(this.cacheConfig.getCollectionName(), this.createCacheKey(key), this.toStoreValue(value), this.cacheConfig.getExpiry(), this.cacheConfig.getValueTranscoder(), clazz);
        return (T)result;
    }

    public void evict(Object key) {
        this.cacheWriter.remove(this.cacheConfig.getCollectionName(), this.createCacheKey(key));
    }

    public boolean evictIfPresent(Object key) {
        return this.cacheWriter.remove(this.cacheConfig.getCollectionName(), this.createCacheKey(key));
    }

    public boolean invalidate() {
        return this.cacheWriter.clear(this.cacheConfig.getCollectionName(), this.cacheConfig.getKeyPrefixFor(this.name)) > 0L;
    }

    public void clear() {
        this.cacheWriter.clear(this.cacheConfig.getCollectionName(), this.cacheConfig.getKeyPrefixFor(this.name));
    }

    protected String createCacheKey(Object key) {
        String convertedKey = this.convertKey(key);
        if (!this.cacheConfig.usePrefix()) {
            return convertedKey;
        }
        return this.prefixCacheKey(convertedKey);
    }

    protected String convertKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Cache '%s' does not allow 'null' key.", this.name));
        }
        if (key instanceof String) {
            return (String)key;
        }
        TypeDescriptor source = TypeDescriptor.forObject((Object)key);
        if (this.conversionService.canConvert(source, TypeDescriptor.valueOf(String.class))) {
            try {
                return (String)this.conversionService.convert(key, String.class);
            }
            catch (ConversionFailedException e) {
                if (this.isCollectionLikeOrMap(source)) {
                    return this.convertCollectionLikeOrMapKey(key, source);
                }
                throw e;
            }
        }
        Method toString = ReflectionUtils.findMethod(key.getClass(), (String)"toString");
        if (toString != null && !Object.class.equals(toString.getDeclaringClass())) {
            return key.toString();
        }
        throw new IllegalStateException(String.format("Cannot convert cache key %s to String. Please register a suitable Converter via 'CouchbaseCacheConfiguration.configureKeyConverters(...)' or override '%s.toString()'.", source, key.getClass().getSimpleName()));
    }

    private String prefixCacheKey(String key) {
        return this.cacheConfig.getKeyPrefixFor(this.name) + key;
    }

    private boolean isCollectionLikeOrMap(TypeDescriptor source) {
        return source.isArray() || source.isCollection() || source.isMap();
    }

    private String convertCollectionLikeOrMapKey(Object key, TypeDescriptor source) {
        if (source.isMap()) {
            StringBuilder target = new StringBuilder("{");
            for (Map.Entry entry : ((Map)key).entrySet()) {
                target.append(this.convertKey(entry.getKey())).append("=").append(this.convertKey(entry.getValue()));
            }
            target.append("}");
            return target.toString();
        }
        if (source.isCollection() || source.isArray()) {
            StringJoiner sj = new StringJoiner(",");
            List<Object> collection = source.isCollection() ? (List<Object>)key : Arrays.asList(ObjectUtils.toObjectArray((Object)key));
            for (Object e : collection) {
                sj.add(this.convertKey(e));
            }
            return "[" + sj.toString() + "]";
        }
        throw new IllegalArgumentException(String.format("Cannot convert cache key %s to String.", key));
    }
}

