/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.convert;

import java.util.Collections;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.couchbase.core.convert.CouchbaseTypeMapper;
import org.springframework.data.couchbase.core.convert.TypeAwareTypeInformationMapper;
import org.springframework.data.couchbase.core.mapping.CouchbaseDocument;
import org.springframework.data.mapping.Alias;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.util.TypeInformation;

public class DefaultCouchbaseTypeMapper
extends DefaultTypeMapper<CouchbaseDocument>
implements CouchbaseTypeMapper {
    public static final String DEFAULT_TYPE_KEY = "_class";
    private final String typeKey;

    public DefaultCouchbaseTypeMapper(String typeKey) {
        super((TypeAliasAccessor)new CouchbaseDocumentTypeAliasAccessor(typeKey), (MappingContext)null, Collections.singletonList(new TypeAwareTypeInformationMapper()));
        this.typeKey = typeKey;
    }

    @Override
    public String getTypeKey() {
        return this.typeKey;
    }

    @Override
    public Alias getTypeAlias(TypeInformation<?> info) {
        return this.getAliasFor(info);
    }

    public static final class CouchbaseDocumentTypeAliasAccessor
    implements TypeAliasAccessor<CouchbaseDocument> {
        private final String typeKey;

        public CouchbaseDocumentTypeAliasAccessor(String typeKey) {
            this.typeKey = typeKey;
        }

        public Alias readAliasFrom(CouchbaseDocument source) {
            if (this.typeKey == null || this.typeKey.length() == 0) {
                return Alias.NONE;
            }
            return Alias.ofNullable((Object)source.get(this.typeKey));
        }

        public void writeTypeTo(CouchbaseDocument sink, Object alias) {
            if (this.typeKey != null) {
                sink.put(this.typeKey, alias);
            }
        }
    }
}

