/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core.query;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.json.JsonValue;
import java.util.Locale;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.StringBasedN1qlQueryParser;
import org.springframework.data.couchbase.repository.support.MappingCouchbaseEntityInformation;
import org.springframework.data.mapping.Alias;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.expression.spel.standard.SpelExpressionParser;

public class StringQuery
extends Query {
    private final CouchbaseQueryMethod queryMethod;
    private final String inlineN1qlQuery;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final ParameterAccessor parameterAccessor;
    private final SpelExpressionParser spelExpressionParser;

    public StringQuery(CouchbaseQueryMethod queryMethod, String n1qlString, QueryMethodEvaluationContextProvider queryMethodEvaluationContextProvider, ParameterAccessor parameterAccessor, SpelExpressionParser spelExpressionParser) {
        this.queryMethod = queryMethod;
        this.inlineN1qlQuery = n1qlString;
        this.evaluationContextProvider = queryMethodEvaluationContextProvider;
        this.parameterAccessor = parameterAccessor;
        this.spelExpressionParser = spelExpressionParser;
    }

    @Override
    public String toN1qlSelectString(ReactiveCouchbaseTemplate template, String scope, String collection, Class domainClass, Class resultClass, boolean isCount, String[] distinctFields, String[] fields) {
        boolean makeCount;
        StringBasedN1qlQueryParser parser = this.getStringN1qlQueryParser(template, scope, collection, domainClass, distinctFields, fields);
        N1QLExpression parsedExpression = parser.getExpression(this.inlineN1qlQuery, this.queryMethod, this.parameterAccessor, this.spelExpressionParser, this.evaluationContextProvider);
        String queryString = parsedExpression.toString();
        JsonValue parameters = parser.getPlaceholderValues(this.parameterAccessor);
        if (parameters instanceof JsonArray) {
            this.setPositionalParameters((JsonArray)parameters);
        } else {
            this.setNamedParameters((JsonObject)parameters);
        }
        StringBuilder statement = new StringBuilder();
        boolean bl = makeCount = isCount && queryString != null && !queryString.toLowerCase(Locale.ROOT).contains("count(");
        if (makeCount) {
            statement.append("SELECT COUNT(*) AS count FROM (");
        }
        statement.append(queryString);
        int[] paramIndexPtr = null;
        JsonValue params = this.getParameters();
        paramIndexPtr = params instanceof JsonArray ? new int[]{((JsonArray)params).size()} : new int[]{-1};
        this.appendWhere(statement, paramIndexPtr, template.getConverter());
        if (!isCount) {
            this.appendSort(statement);
            this.appendSkipAndLimit(statement);
        }
        if (makeCount) {
            statement.append(") predicate_query");
        }
        return statement.toString();
    }

    private StringBasedN1qlQueryParser getStringN1qlQueryParser(ReactiveCouchbaseTemplate template, String scopeName, String collectionName, Class domainClass, String[] distinctFields, String[] fields) {
        String typeKey = template.getConverter().getTypeKey();
        CouchbasePersistentEntity persistentEntity = (CouchbasePersistentEntity)template.getConverter().getMappingContext().getRequiredPersistentEntity(domainClass);
        MappingCouchbaseEntityInformation info = new MappingCouchbaseEntityInformation(persistentEntity);
        String typeValue = info.getJavaType().getName();
        ClassTypeInformation typeInfo = ClassTypeInformation.from((Class)info.getJavaType());
        Alias alias = template.getConverter().getTypeAlias((TypeInformation<?>)typeInfo);
        if (alias != null && alias.isPresent()) {
            typeValue = alias.toString();
        }
        StringBasedN1qlQueryParser sbnqp = new StringBasedN1qlQueryParser(this.inlineN1qlQuery, this.queryMethod, template.getBucketName(), scopeName, collectionName, template.getConverter(), typeKey, typeValue, this.parameterAccessor, new SpelExpressionParser(), this.evaluationContextProvider);
        return sbnqp;
    }

    @Override
    public String toN1qlRemoveString(ReactiveCouchbaseTemplate template, String scopeName, String collectionName, Class domainClass) {
        return this.toN1qlSelectString(template, scopeName, collectionName, domainClass, domainClass, false, null, null);
    }
}

