/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.RawJsonTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.GetAndTouchOptions;
import com.couchbase.client.java.kv.GetOptions;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveFindByIdOperation;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveFindByIdOperationSupport
implements ReactiveFindByIdOperation {
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveFindByIdOperationSupport.class);

    ReactiveFindByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveFindByIdOperation.ReactiveFindById<T> findById(Class<T> domainType) {
        return new ReactiveFindByIdSupport<T>(this.template, domainType, null, null, null, null, null, this.template.support());
    }

    static class ReactiveFindByIdSupport<T>
    implements ReactiveFindByIdOperation.ReactiveFindById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<T> domainType;
        private final String scope;
        private final String collection;
        private final CommonOptions<?> options;
        private final List<String> fields;
        private final ReactiveTemplateSupport support;
        private final Duration expiry;

        ReactiveFindByIdSupport(ReactiveCouchbaseTemplate template, Class<T> domainType, String scope, String collection, CommonOptions<?> options, List<String> fields, Duration expiry, ReactiveTemplateSupport support) {
            this.template = template;
            this.domainType = domainType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.fields = fields;
            this.expiry = expiry;
            this.support = support;
        }

        @Override
        public Mono<T> one(String id) {
            CommonOptions<?> gOptions = this.initGetOptions();
            PseudoArgs pArgs = new PseudoArgs(this.template, this.scope, this.collection, gOptions, this.domainType);
            LOG.trace("findById {}", pArgs);
            return Mono.just((Object)id).flatMap(docId -> {
                ReactiveCollection reactive = this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getCollection(pArgs.getCollection()).reactive();
                if (pArgs.getOptions() instanceof GetAndTouchOptions) {
                    return reactive.getAndTouch(docId, this.expiryToUse(), (GetAndTouchOptions)pArgs.getOptions());
                }
                return reactive.get(docId, (GetOptions)pArgs.getOptions());
            }).flatMap(result -> this.support.decodeEntity(id, (String)result.contentAs(String.class), result.cas(), this.domainType, pArgs.getScope(), pArgs.getCollection())).onErrorResume(throwable -> {
                if (throwable instanceof RuntimeException && throwable instanceof DocumentNotFoundException) {
                    return Mono.empty();
                }
                return Mono.error((Throwable)throwable);
            }).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<? extends T> all(Collection<String> ids) {
            return Flux.fromIterable(ids).flatMap(this::one);
        }

        @Override
        public ReactiveFindByIdOperation.TerminatingFindById<T> withOptions(GetOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveFindByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, (CommonOptions<?>)options, this.fields, this.expiry, this.support);
        }

        @Override
        public ReactiveFindByIdOperation.FindByIdWithOptions<T> inCollection(String collection) {
            return new ReactiveFindByIdSupport<T>(this.template, this.domainType, this.scope, collection, this.options, this.fields, this.expiry, this.support);
        }

        @Override
        public ReactiveFindByIdOperation.FindByIdInCollection<T> inScope(String scope) {
            return new ReactiveFindByIdSupport<T>(this.template, this.domainType, scope, this.collection, this.options, this.fields, this.expiry, this.support);
        }

        @Override
        public ReactiveFindByIdOperation.FindByIdInScope<T> project(String ... fields) {
            Assert.notNull((Object)fields, (String)"Fields must not be null");
            return new ReactiveFindByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, Arrays.asList(fields), this.expiry, this.support);
        }

        @Override
        public ReactiveFindByIdOperation.FindByIdWithProjection<T> withExpiry(Duration expiry) {
            return new ReactiveFindByIdSupport<T>(this.template, this.domainType, this.scope, this.collection, this.options, this.fields, expiry, this.support);
        }

        private CommonOptions<?> initGetOptions() {
            GetAndTouchOptions getOptions;
            if (this.expiry != null || this.options instanceof GetAndTouchOptions) {
                GetAndTouchOptions gOptions;
                GetAndTouchOptions getAndTouchOptions = gOptions = this.options != null ? (GetAndTouchOptions)this.options : GetAndTouchOptions.getAndTouchOptions();
                if (gOptions.build().transcoder() == null) {
                    gOptions.transcoder((Transcoder)RawJsonTranscoder.INSTANCE);
                }
                getOptions = gOptions;
            } else {
                GetOptions gOptions;
                GetOptions getOptions2 = gOptions = this.options != null ? (GetOptions)this.options : GetOptions.getOptions();
                if (gOptions.build().transcoder() == null) {
                    gOptions.transcoder((Transcoder)RawJsonTranscoder.INSTANCE);
                }
                if (this.fields != null && !this.fields.isEmpty()) {
                    gOptions.project(this.fields);
                }
                getOptions = gOptions;
            }
            return getOptions;
        }

        private Duration expiryToUse() {
            Duration expiryToUse = this.expiry;
            if ((expiryToUse != null || this.options instanceof GetAndTouchOptions) && expiryToUse == null) {
                CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.template.getConverter().getMappingContext().getRequiredPersistentEntity(this.domainType);
                expiryToUse = entity.getExpiryDuration();
            }
            return expiryToUse;
        }
    }
}

