/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.springframework.data.couchbase.core.ReactiveCouchbaseOperations;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.ReactiveCouchbaseRepository;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.CouchbaseRepositoryBase;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveCouchbaseRepository<T, ID>
extends CouchbaseRepositoryBase<T, ID>
implements ReactiveCouchbaseRepository<T, ID> {
    private final ReactiveCouchbaseOperations operations;

    public SimpleReactiveCouchbaseRepository(CouchbaseEntityInformation<T, String> entityInformation, ReactiveCouchbaseOperations operations, Class<?> repositoryInterface) {
        super(entityInformation, repositoryInterface);
        this.operations = operations;
    }

    public <S extends T> Mono<S> save(S entity) {
        boolean existingDocument;
        Assert.notNull(entity, (String)"Entity must not be null!");
        CouchbasePersistentEntity mapperEntity = (CouchbasePersistentEntity)this.operations.getConverter().getMappingContext().getPersistentEntity(entity.getClass());
        CouchbasePersistentProperty versionProperty = (CouchbasePersistentProperty)mapperEntity.getVersionProperty();
        boolean versionPresent = versionProperty != null;
        Long version = versionProperty == null || versionProperty.getField() == null ? null : (Long)ReflectionUtils.getField((Field)versionProperty.getField(), entity);
        boolean bl = existingDocument = version != null && version > 0L;
        Mono<S> result = !versionPresent ? this.operations.upsertById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).one(entity) : (existingDocument ? this.operations.replaceById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).one(entity) : this.operations.insertById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).one(entity));
        return result;
    }

    public Flux<T> findAll(Sort sort) {
        return this.findAll(new Query().with(sort));
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return Flux.fromIterable(entities).flatMap(e -> this.save(e));
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"The given Iterable of entities must not be null!");
        return Flux.from(entityStream).flatMap(this::save);
    }

    public Mono<T> findById(ID id) {
        return this.operations.findById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).one(id.toString());
    }

    public Mono<T> findById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given Publisher must not be null!");
        return Mono.from(publisher).flatMap(this::findById);
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.operations.existsById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).one(id.toString());
    }

    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given Publisher must not be null!");
        return Mono.from(publisher).flatMap(this::existsById);
    }

    public Flux<T> findAll() {
        return this.findAll(new Query());
    }

    public Flux<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of ids must not be null!");
        List<String> convertedIds = Streamable.of(ids).stream().map(Objects::toString).collect(Collectors.toList());
        return this.operations.findById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).all(convertedIds);
    }

    public Flux<T> findAllById(Publisher<ID> entityStream) {
        Assert.notNull(entityStream, (String)"The given entityStream must not be null!");
        return Flux.from(entityStream).flatMap(this::findById);
    }

    public Mono<Void> deleteById(ID id) {
        return this.operations.removeById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).one(id.toString()).then();
    }

    public Mono<Void> deleteById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given id must not be null!");
        return Mono.from(publisher).flatMap(this::deleteById);
    }

    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, (String)"Entity must not be null!");
        return this.operations.removeById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).one(this.getId(entity)).then();
    }

    public Mono<Void> deleteAllById(Iterable<? extends ID> ids) {
        return this.operations.removeById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).all(Streamable.of(ids).map(Object::toString).toList()).then();
    }

    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        return this.operations.removeById(this.getJavaType()).inScope(this.getScope()).inCollection(this.getCollection()).all(Streamable.of(entities).map(this::getId).toList()).then();
    }

    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"The given publisher of entities must not be null!");
        return Flux.from(entityStream).flatMap(this::delete).single();
    }

    public Mono<Long> count() {
        return this.operations.findByQuery(this.getJavaType()).withConsistency(this.buildQueryScanConsistency()).inScope(this.getScope()).inCollection(this.getCollection()).count();
    }

    public Mono<Void> deleteAll() {
        return this.operations.removeByQuery(this.getJavaType()).withConsistency(this.buildQueryScanConsistency()).inScope(this.getScope()).inCollection(this.getCollection()).all().then();
    }

    private Flux<T> findAll(Query query) {
        return this.operations.findByQuery(this.getJavaType()).withConsistency(this.buildQueryScanConsistency()).inScope(this.getScope()).inCollection(this.getCollection()).matching(query).all();
    }

    @Override
    public ReactiveCouchbaseOperations getOperations() {
        return this.operations;
    }
}

