/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.java.analytics.AnalyticsOptions;
import com.couchbase.client.java.analytics.AnalyticsScanConsistency;
import com.couchbase.client.java.analytics.ReactiveAnalyticsResult;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveFindByAnalyticsOperation;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.query.AnalyticsQuery;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveFindByAnalyticsOperationSupport
implements ReactiveFindByAnalyticsOperation {
    private static final AnalyticsQuery ALL_QUERY = new AnalyticsQuery();
    private final ReactiveCouchbaseTemplate template;

    public ReactiveFindByAnalyticsOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveFindByAnalyticsOperation.ReactiveFindByAnalytics<T> findByAnalytics(Class<T> domainType) {
        return new ReactiveFindByAnalyticsSupport<T>(this.template, domainType, domainType, ALL_QUERY, null, null, null, null, this.template.support());
    }

    static class ReactiveFindByAnalyticsSupport<T>
    implements ReactiveFindByAnalyticsOperation.ReactiveFindByAnalytics<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final AnalyticsQuery query;
        private final AnalyticsScanConsistency scanConsistency;
        private final String scope;
        private final String collection;
        private final AnalyticsOptions options;
        private final ReactiveTemplateSupport support;

        ReactiveFindByAnalyticsSupport(ReactiveCouchbaseTemplate template, Class<?> domainType, Class<T> returnType, AnalyticsQuery query, AnalyticsScanConsistency scanConsistency, String scope, String collection, AnalyticsOptions options, ReactiveTemplateSupport support) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = query;
            this.scanConsistency = scanConsistency;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.support = support;
        }

        @Override
        public ReactiveFindByAnalyticsOperation.TerminatingFindByAnalytics<T> matching(AnalyticsQuery query) {
            return new ReactiveFindByAnalyticsSupport<T>(this.template, this.domainType, this.returnType, query, this.scanConsistency, this.scope, this.collection, this.options, this.support);
        }

        @Override
        @Deprecated
        public ReactiveFindByAnalyticsOperation.FindByAnalyticsWithQuery<T> consistentWith(AnalyticsScanConsistency scanConsistency) {
            return new ReactiveFindByAnalyticsSupport<T>(this.template, this.domainType, this.returnType, this.query, scanConsistency, this.scope, this.collection, this.options, this.support);
        }

        @Override
        public ReactiveFindByAnalyticsOperation.FindByAnalyticsWithQuery<T> withConsistency(AnalyticsScanConsistency scanConsistency) {
            return new ReactiveFindByAnalyticsSupport<T>(this.template, this.domainType, this.returnType, this.query, scanConsistency, this.scope, this.collection, this.options, this.support);
        }

        @Override
        public <R> ReactiveFindByAnalyticsOperation.FindByAnalyticsWithConsistency<R> as(Class<R> returnType) {
            Assert.notNull(returnType, (String)"returnType must not be null!");
            return new ReactiveFindByAnalyticsSupport<R>(this.template, this.domainType, returnType, this.query, this.scanConsistency, this.scope, this.collection, this.options, this.support);
        }

        @Override
        public Mono<T> one() {
            return this.all().singleOrEmpty();
        }

        @Override
        public Mono<T> first() {
            return this.all().next();
        }

        @Override
        public Flux<T> all() {
            return Flux.defer(() -> {
                String statement = this.assembleEntityQuery(false);
                return this.template.getCouchbaseClientFactory().getCluster().reactive().analyticsQuery(statement, this.buildAnalyticsOptions()).onErrorMap(throwable -> {
                    if (throwable instanceof RuntimeException) {
                        return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                    }
                    return throwable;
                }).flatMapMany(ReactiveAnalyticsResult::rowsAsObject).flatMap(row -> {
                    String id = "";
                    long cas = 0L;
                    if (row.getString("__id") == null) {
                        return Flux.error((Throwable)new CouchbaseException("analytics query did not project __id. Either use #{#n1ql.selectEntity} or project __id and __cas : " + statement));
                    }
                    id = row.getString("__id");
                    if (row.getLong("__cas") == null) {
                        return Flux.error((Throwable)new CouchbaseException("analytics query did not project __cas. Either use #{#n1ql.selectEntity} or project __id and __cas : " + statement));
                    }
                    cas = row.getLong("__cas");
                    row.removeKey("__id");
                    row.removeKey("__cas");
                    return this.support.decodeEntity(id, row.toString(), cas, this.returnType, null, null);
                });
            });
        }

        @Override
        public Mono<Long> count() {
            return Mono.defer(() -> {
                String statement = this.assembleEntityQuery(true);
                return this.template.getCouchbaseClientFactory().getCluster().reactive().analyticsQuery(statement, this.buildAnalyticsOptions()).onErrorMap(throwable -> {
                    if (throwable instanceof RuntimeException) {
                        return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                    }
                    return throwable;
                }).flatMapMany(ReactiveAnalyticsResult::rowsAsObject).map(row -> row.getLong((String)row.getNames().iterator().next())).next();
            });
        }

        @Override
        public Mono<Boolean> exists() {
            return this.count().map(count -> count > 0L);
        }

        @Override
        public ReactiveFindByAnalyticsOperation.TerminatingFindByAnalytics<T> withOptions(AnalyticsOptions options) {
            Assert.notNull((Object)options, (String)"Options must not be null.");
            return new ReactiveFindByAnalyticsSupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, this.collection, options, this.support);
        }

        @Override
        public ReactiveFindByAnalyticsOperation.FindByAnalyticsInCollection<T> inScope(String scope) {
            return new ReactiveFindByAnalyticsSupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, scope, this.collection, this.options, this.support);
        }

        @Override
        public ReactiveFindByAnalyticsOperation.FindByAnalyticsWithConsistency<T> inCollection(String collection) {
            return new ReactiveFindByAnalyticsSupport<T>(this.template, this.domainType, this.returnType, this.query, this.scanConsistency, this.scope, collection, this.options, this.support);
        }

        private String assembleEntityQuery(boolean count) {
            String bucket = "`" + this.template.getBucketName() + "`";
            StringBuilder statement = new StringBuilder("SELECT ");
            if (count) {
                statement.append("count(*) as __count");
            } else {
                statement.append("meta().id as __id, meta().cas as __cas, ").append(bucket).append(".*");
            }
            String dataset = this.support.getJavaNameForEntity(this.domainType);
            statement.append(" FROM ").append(dataset);
            this.query.appendSort(statement);
            this.query.appendSkipAndLimit(statement);
            return statement.toString();
        }

        private AnalyticsOptions buildAnalyticsOptions() {
            AnalyticsOptions options = AnalyticsOptions.analyticsOptions();
            if (this.scanConsistency != null) {
                options.scanConsistency(this.scanConsistency);
            }
            return options;
        }
    }
}

