/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.cache;

import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.Scope;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.UpsertOptions;
import com.couchbase.client.java.query.QueryMetrics;
import com.couchbase.client.java.query.QueryOptions;
import com.couchbase.client.java.query.QueryResult;
import com.couchbase.client.java.query.QueryScanConsistency;
import java.time.Duration;
import org.springframework.data.couchbase.CouchbaseClientFactory;
import org.springframework.data.couchbase.cache.CouchbaseCacheWriter;

public class DefaultCouchbaseCacheWriter
implements CouchbaseCacheWriter {
    private final CouchbaseClientFactory clientFactory;

    public DefaultCouchbaseCacheWriter(CouchbaseClientFactory clientFactory) {
        this.clientFactory = clientFactory;
    }

    @Override
    public void put(String collectionName, String key, Object value, Duration expiry, Transcoder transcoder) {
        UpsertOptions options = UpsertOptions.upsertOptions();
        if (expiry != null) {
            options.expiry(expiry);
        }
        if (transcoder != null) {
            options.transcoder(transcoder);
        }
        this.getCollection(collectionName).upsert(key, value, options);
    }

    @Override
    public Object putIfAbsent(String collectionName, String key, Object value, Duration expiry, Transcoder transcoder) {
        InsertOptions options = InsertOptions.insertOptions();
        if (expiry != null) {
            options.expiry(expiry);
        }
        if (transcoder != null) {
            options.transcoder(transcoder);
        }
        try {
            this.getCollection(collectionName).insert(key, value, options);
            return null;
        }
        catch (DocumentExistsException ex) {
            return this.get(collectionName, key, transcoder);
        }
    }

    @Override
    public Object get(String collectionName, String key, Transcoder transcoder) {
        try {
            return this.getCollection(collectionName).get(key, GetOptions.getOptions().transcoder(transcoder)).contentAs(Object.class);
        }
        catch (DocumentNotFoundException ex) {
            return null;
        }
    }

    @Override
    public boolean remove(String collectionName, String key) {
        try {
            this.getCollection(collectionName).remove(key);
            return true;
        }
        catch (DocumentNotFoundException ex) {
            return false;
        }
    }

    @Override
    public long clear(String collectionName, String pattern) {
        QueryResult result = this.clientFactory.getScope().query("DELETE FROM `" + this.getCollection(collectionName).name() + "` where meta().id LIKE $pattern", QueryOptions.queryOptions().scanConsistency(QueryScanConsistency.REQUEST_PLUS).metrics(true).parameters(JsonObject.create().put("pattern", pattern + "%")));
        return result.metaData().metrics().map(QueryMetrics::mutationCount).orElse(0L);
    }

    private Collection getCollection(String collectionName) {
        Scope scope = this.clientFactory.getScope();
        if (collectionName == null) {
            if (!scope.name().equals("_default")) {
                throw new IllegalStateException("A collectionName must be provided if a non-default scope is used!");
            }
            return this.clientFactory.getBucket().defaultCollection();
        }
        return scope.collection(collectionName);
    }
}

