/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.webclient.observation.ObservationWebClientCustomizer;
import org.springframework.cloud.vault.config.VaultReactiveAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.vault.client.WebClientCustomizer;
import org.springframework.web.reactive.function.client.ClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.DefaultClientRequestObservationConvention;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Observation.class, WebClient.class, Flux.class, ObservationWebClientCustomizer.class})
@AutoConfigureBefore(value={VaultReactiveAutoConfiguration.class})
public class VaultReactiveObservationAutoConfiguration {
    @Bean
    @ConditionalOnSingleCandidate(value=ObservationRegistry.class)
    public WebClientCustomizer observationVaultWebClientCustomizer(ObservationRegistry observationRegistry) {
        return webClientBuilder -> new ObservationWebClientCustomizer(observationRegistry, (ClientRequestObservationConvention)new DefaultClientRequestObservationConvention()).customize(webClientBuilder);
    }
}

