/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.vault.config.VaultServiceInstanceProvider;

public class DiscoveryClientVaultServiceInstanceProvider
implements VaultServiceInstanceProvider {
    private static final Log log = LogFactory.getLog(DiscoveryClientVaultServiceInstanceProvider.class);
    private final DiscoveryClient client;

    public DiscoveryClientVaultServiceInstanceProvider(DiscoveryClient client) {
        this.client = client;
    }

    @Override
    public ServiceInstance getVaultServerInstance(String serviceId) {
        log.debug((Object)("Locating Vault server (" + serviceId + ") via discovery"));
        List instances = this.client.getInstances(serviceId);
        if (instances.isEmpty()) {
            throw new IllegalStateException("No instances found of Vault server (" + serviceId + ")");
        }
        ServiceInstance instance = (ServiceInstance)instances.get(0);
        log.debug((Object)("Located Vault server (" + serviceId + ") via discovery: " + String.valueOf(instance)));
        return instance;
    }
}

