/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.utils;

import java.util.Objects;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public final class CacheKeyCreatorUtils {
    private CacheKeyCreatorUtils() {
    }

    public static String createChannelCacheKey(@Nullable String binderName, String outputName, BindingServiceProperties bindingServiceProperties) {
        String finalBinderName = CacheKeyCreatorUtils.getBinderNameIfNeeded(binderName, outputName, bindingServiceProperties);
        return CacheKeyCreatorUtils.createChannelCacheKey(finalBinderName, outputName);
    }

    public static String getBinderNameIfNeeded(@Nullable String binderName, String outputName, BindingServiceProperties bindingServiceProperties) {
        if (Objects.isNull(binderName)) {
            return bindingServiceProperties.getBinder(outputName);
        }
        return binderName;
    }

    public static String createChannelCacheKey(String outputName, BindingServiceProperties bindingServiceProperties) {
        String binderName = bindingServiceProperties.getBinder(outputName);
        return CacheKeyCreatorUtils.createChannelCacheKey(binderName, outputName);
    }

    public static String createChannelCacheKey(String binderName, String outputName) {
        if (StringUtils.hasText((String)binderName)) {
            return binderName + ":" + outputName;
        }
        return outputName;
    }
}

