/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.endpoint;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.cloud.stream.binding.Bindable;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.ObjectMapper;

@Endpoint(id="channels")
public class ChannelsEndpoint
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final BindingServiceProperties properties;

    public ChannelsEndpoint(BindingServiceProperties properties) {
        this.properties = properties;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    @ReadOperation
    public Map<String, Object> channels() {
        Collection adapters = this.applicationContext.getBeansOfType(Bindable.class).values();
        ChannelsMetaData map = new ChannelsMetaData();
        Map<String, BindingProperties> inputs = map.getInputs();
        Map<String, BindingProperties> outputs = map.getOutputs();
        for (Bindable factory : adapters) {
            for (String name : factory.getInputs()) {
                inputs.put(name, this.properties.getBindingProperties(name));
            }
            for (String name : factory.getOutputs()) {
                outputs.put(name, this.properties.getBindingProperties(name));
            }
        }
        return (Map)new ObjectMapper().convertValue((Object)map, (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public static class ChannelsMetaData {
        private Map<String, BindingProperties> inputs = new LinkedHashMap<String, BindingProperties>();
        private Map<String, BindingProperties> outputs = new LinkedHashMap<String, BindingProperties>();

        public Map<String, BindingProperties> getInputs() {
            return this.inputs;
        }

        public Map<String, BindingProperties> getOutputs() {
            return this.outputs;
        }
    }
}

