/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.config;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ParseException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.config.IntegrationConverter;
import org.springframework.integration.expression.SpelPropertyAccessorRegistrar;
import org.springframework.integration.json.JacksonPropertyAccessor;

@Configuration(proxyBeanMethods=false)
@Role(value=2)
public class SpelExpressionConverterConfiguration {
    @Bean
    public static SpelPropertyAccessorRegistrar spelPropertyAccessorRegistrar() {
        return new SpelPropertyAccessorRegistrar().add(new PropertyAccessor[]{new JacksonPropertyAccessor()});
    }

    @Bean
    @ConfigurationPropertiesBinding
    @IntegrationConverter
    public Converter<String, Expression> spelConverter(ConfigurableApplicationContext context) {
        SpelConverter converter = new SpelConverter();
        ConfigurableConversionService cs = (ConfigurableConversionService)context.getBeanFactory().getConversionService();
        if (cs != null) {
            cs.addConverter((Converter)converter);
            cs.addConverter((Converter)new NumberToStringSpelConverter());
            cs.addConverter((Converter)new BooleanToStringSpelConverter());
        }
        return converter;
    }

    public static class SpelConverter
    extends AbstractSpelConverter<String> {
        public Expression convert(String source) {
            return this.doConvert(source);
        }
    }

    public static class NumberToStringSpelConverter
    extends AbstractSpelConverter<Number> {
        public Expression convert(Number source) {
            String value = source.toString();
            return this.doConvert(value);
        }
    }

    public static class BooleanToStringSpelConverter
    extends AbstractSpelConverter<Boolean> {
        public Expression convert(Boolean source) {
            String value = source.toString();
            return this.doConvert(value);
        }
    }

    public static abstract class AbstractSpelConverter<T>
    implements Converter<T, Expression> {
        private SpelExpressionParser parser = new SpelExpressionParser();
        @Autowired
        @Qualifier(value="integrationEvaluationContext")
        @Lazy
        private EvaluationContext evaluationContext;

        public Expression doConvert(String source) {
            try {
                Expression expression = this.parser.parseExpression(source);
                if (expression instanceof SpelExpression) {
                    ((SpelExpression)expression).setEvaluationContext(this.evaluationContext);
                }
                return expression;
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(String.format("Could not convert '%s' into a SpEL expression", source), e);
            }
        }
    }
}

