/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binding;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binding.InputBindingLifecycle;
import org.springframework.cloud.stream.binding.OutputBindingLifecycle;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class BindingsLifecycleController {
    private final List<InputBindingLifecycle> inputBindingLifecycles;
    private final List<OutputBindingLifecycle> outputBindingsLifecycles;
    private final ObjectMapper objectMapper;

    public BindingsLifecycleController(List<InputBindingLifecycle> inputBindingLifecycles, List<OutputBindingLifecycle> outputBindingsLifecycles) {
        Assert.notEmpty(inputBindingLifecycles, (String)"'inputBindingLifecycles' must not be null or empty");
        this.inputBindingLifecycles = inputBindingLifecycles;
        this.outputBindingsLifecycles = outputBindingsLifecycles;
        this.objectMapper = new ObjectMapper();
        try {
            Class javaTimeModuleClass = ClassUtils.forName((String)"com.fasterxml.jackson.datatype.jsr310.JavaTimeModule", (ClassLoader)ClassUtils.getDefaultClassLoader());
            Module javaTimeModule = (Module)BeanUtils.instantiateClass((Class)javaTimeModuleClass);
            this.objectMapper.registerModule(javaTimeModule);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void stop(String bindingName) {
        this.changeState(bindingName, State.STOPPED);
    }

    public void start(String bindingName) {
        this.changeState(bindingName, State.STARTED);
    }

    public void pause(String bindingName) {
        this.changeState(bindingName, State.PAUSED);
    }

    public void resume(String bindingName) {
        this.changeState(bindingName, State.RESUMED);
    }

    public void changeState(String bindingName, State state) {
        List<Binding<?>> bindingList = this.locateBinding(bindingName);
        if (!bindingList.isEmpty()) {
            switch (state) {
                case STARTED: {
                    bindingList.stream().forEach(Binding::start);
                    break;
                }
                case STOPPED: {
                    bindingList.stream().forEach(Binding::stop);
                    break;
                }
                case PAUSED: {
                    bindingList.stream().forEach(Binding::pause);
                    break;
                }
                case RESUMED: {
                    bindingList.stream().forEach(Binding::resume);
                    break;
                }
            }
        }
    }

    public List<Map<?, ?>> queryStates() {
        ArrayList bindings = new ArrayList(this.gatherInputBindings());
        bindings.addAll(this.gatherOutputBindings());
        return (List)this.objectMapper.convertValue(bindings, List.class);
    }

    public List<Binding<?>> queryState(String name) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        return this.locateBinding(name);
    }

    private List<Binding<?>> gatherInputBindings() {
        ArrayList inputBindings = new ArrayList();
        for (InputBindingLifecycle inputBindingLifecycle : this.inputBindingLifecycles) {
            Collection lifecycleInputBindings = (Collection)new DirectFieldAccessor((Object)inputBindingLifecycle).getPropertyValue("inputBindings");
            inputBindings.addAll(lifecycleInputBindings);
        }
        return inputBindings;
    }

    private List<Binding<?>> gatherOutputBindings() {
        ArrayList outputBindings = new ArrayList();
        for (OutputBindingLifecycle inputBindingLifecycle : this.outputBindingsLifecycles) {
            Collection lifecycleInputBindings = (Collection)new DirectFieldAccessor((Object)inputBindingLifecycle).getPropertyValue("outputBindings");
            outputBindings.addAll(lifecycleInputBindings);
        }
        return outputBindings;
    }

    private List<Binding<?>> locateBinding(String name) {
        Stream bindings = Stream.concat(this.gatherInputBindings().stream(), this.gatherOutputBindings().stream());
        return bindings.filter(binding -> name.equals(binding.getBindingName())).collect(Collectors.toList());
    }

    public static enum State {
        STARTED,
        STOPPED,
        PAUSED,
        RESUMED;

    }
}

